/*
 * dungeon_generation_failed.hpp
 *
 * Exception class that can be thrown during dungeon generation
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */
  
#ifndef DUNGEON_GENERATION_FAILED_HPP
#define DUNGEON_GENERATION_FAILED_HPP

#include <exception>

class DungeonGenerationFailed : public std::exception {
public:
    // (TODO) probably should add more helpful error messages to this, since the dungeon
    // generator can fail (in several different ways!) if there is bad input. (e.g. if
    // you ask for required items but have not got any DungeonStuff directives with
    // weights given.)
    DungeonGenerationFailed() { } 
    virtual const char * what() const throw() { return "dungeon generator failure"; }
};

#endif
