/*
 * FILE:
 *   timer.hpp
 *
 * PURPOSE:
 *   Functions for time management and sleeping for a specified time
 *
 * AUTHOR:
 *   Stephen Thompson, 2008
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 */

#ifndef COERCRI_TIMER_HPP
#define COERCRI_TIMER_HPP

namespace Coercri {

    // NOTE: Timer is thread safe -- multiple threads are allowed to
    // call into the same Timer objects concurrently without problems.
    
    class Timer {
    public:
        virtual ~Timer() { }

        // Get current "clock time" in milliseconds -- note does not necessarily start from zero.
        virtual unsigned int getMsec() = 0;

        // Sleep for at least the given number of milliseconds. Yields the CPU in the meantime.
        virtual void sleepMsec(int msec) = 0;
    };

}

#endif
