/*
 * FILE:
 *   sound_driver.hpp
 *
 * PURPOSE:
 *   Interface for loading and playing sounds
 *
 * AUTHOR:
 *   Stephen Thompson, 2008
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 */

#ifndef COERCRI_SOUND_DRIVER_HPP
#define COERCRI_SOUND_DRIVER_HPP

#include "boost/shared_ptr.hpp"
#include <iosfwd>

namespace Coercri {

    class Sound;
    
    class SoundDriver {
    public:
        virtual ~SoundDriver() { }
        virtual boost::shared_ptr<Sound> loadSound(boost::shared_ptr<std::istream> str) = 0;
        virtual void playSound(boost::shared_ptr<Sound> sound, int frequency) = 0;
    };

}

#endif
