/*
 * FILE:
 *   sdl_timer.hpp
 *
 * PURPOSE:
 *   SDL implementation of timer interface
 *
 * AUTHOR:
 *   Stephen Thompson, 2008
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 */

#ifndef COERCRI_SDL_TIMER_HPP
#define COERCRI_SDL_TIMER_HPP

#include "../../timer/timer.hpp"
#include "../core/sdl_subsystem_handle.hpp"

#include "boost/thread/mutex.hpp"

namespace Coercri {

    class SDLTimer : public Timer {
    public:
        SDLTimer();
        virtual unsigned int getMsec();
        virtual void sleepMsec(int amount);

    private:
        SDLSubSystemHandle timer_subsystem;
        boost::mutex mutex;
    };

}

#endif
