/*
 * FILE:
 *   sdl_timer.cpp
 *
 * PURPOSE:
 *   SDL implementation of Timer interface
 *
 * AUTHOR:
 *   Stephen Thompson, 2008
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 */

#include "sdl_timer.hpp"

#include "SDL.h"

#include "boost/thread/locks.hpp"

namespace Coercri {

    SDLTimer::SDLTimer()
        : timer_subsystem(SDL_INIT_TIMER)
    { }

    unsigned int SDLTimer::getMsec()
    {
        // not sure if SDL_GetTicks is thread safe, so put in a lock just to be certain...
        boost::lock_guard<boost::mutex> lock(mutex);
        return SDL_GetTicks();
    }

    void SDLTimer::sleepMsec(int msec)
    {
        SDL_Delay(msec);
    }
}
