/*
 * FILE:
 *   sdl_sound_driver.hpp
 *
 * PURPOSE:
 *   SDL implementation of SoundDriver
 *
 * AUTHOR:
 *   Stephen Thompson, 2008
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 */

#ifndef COERCRI_SDL_SOUND_DRIVER_HPP
#define COERCRI_SDL_SOUND_DRIVER_HPP

#include "../../sound/sound_driver.hpp"
#include "../core/sdl_subsystem_handle.hpp"

#include "SDL.h"
#include <list>

namespace Coercri {

    class Voice;
    
    class SDLSoundDriver : public SoundDriver {
    public:
        // volume_factor determines how loud the sound will play. 0.25
        // is a good default. Note that too high values will cause
        // "crackling" effects.
        explicit SDLSoundDriver(float volume_factor);
        virtual ~SDLSoundDriver();
        virtual boost::shared_ptr<Sound> loadSound(boost::shared_ptr<std::istream> str);
        virtual void playSound(boost::shared_ptr<Sound> sound, int frequency);

    private:
        static void audioCallback(void *userdata, Uint8 *stream, int len);
        
    private:
        SDLSubSystemHandle audio_subsystem_handle;
        SDL_AudioSpec spec;
        std::list<Voice> voices;
        float volume_factor;
    };
}

#endif
