/*
 * FILE:
 *   sdl_window.hpp
 *
 * PURPOSE:
 *   Implementation of Window for SDL
 *   
 * AUTHOR:
 *   Stephen Thompson, 2008
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 */

#ifndef COERCRI_SDL_WINDOW_HPP
#define COERCRI_SDL_WINDOW_HPP

#include "../../gfx/window.hpp"

namespace Coercri {

    class SDLWindow : public Window {
    public:
        explicit SDLWindow();

        virtual void getSize(int &w, int &h) const;
        virtual bool hasFocus() const;
        virtual void showMousePointer(bool shown);
        virtual void switchToWindowed(int w, int h);
        virtual void switchToFullScreen(int w, int h);
        virtual std::auto_ptr<GfxContext> createGfxContext();
        
        const std::vector<WindowListener*> getListeners() const { return listeners; }

        bool need_window_resize;  // see SDLGfxDriver::pollEvents.
        
    private:
        // prevent copying
        SDLWindow(const SDLWindow&);
        void operator=(const SDLWindow&);
    };

}

#endif
