/*
 * FILE:
 *   sdl_window.cpp
 *
 * AUTHOR:
 *   Stephen Thompson, 2008
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 */

#include "sdl_gfx_context.hpp"
#include "sdl_window.hpp"
#include "../../core/coercri_error.hpp"

#include "SDL.h"

namespace Coercri {

    extern unsigned int g_sdl_required_flags;
    extern bool g_sdl_has_focus;

    SDLWindow::SDLWindow()
        : need_window_resize(false)
    {
        g_sdl_has_focus = true;
    }

    void SDLWindow::getSize(int &w, int &h) const
    {
        SDL_Surface *surf = SDL_GetVideoSurface();
        if (surf) {
            w = surf->w;
            h = surf->h;
        } else {
            w = h = 0;
        }
    }

    bool SDLWindow::hasFocus() const
    {
        return g_sdl_has_focus;
    }

    void SDLWindow::showMousePointer(bool shown)
    {
        SDL_ShowCursor(shown ? SDL_ENABLE : SDL_DISABLE);
    }
    
    void SDLWindow::switchToWindowed(int w, int h)
    {
        bool currently_full_screen = ((g_sdl_required_flags & SDL_FULLSCREEN) != 0);
        g_sdl_required_flags &= (~SDL_FULLSCREEN);

        SDL_SetVideoMode(w, h, 0, g_sdl_required_flags);

        if (currently_full_screen) {
            // Need two calls to SetVideoMode to work around a bug when SDL is used with xmonad
            SDL_SetVideoMode(w, h, 0, g_sdl_required_flags);
        }
        
        need_window_resize = true;
    }

    void SDLWindow::switchToFullScreen(int w, int h)
    {
        g_sdl_required_flags |= SDL_FULLSCREEN;
        SDL_SetVideoMode(w, h, 0, g_sdl_required_flags);
        need_window_resize = true;
    }

    std::auto_ptr<GfxContext> SDLWindow::createGfxContext()
    {
        std::auto_ptr<GfxContext> p(new SDLGfxContext(*SDL_GetVideoSurface()));
        return p;
    }
}
