/*
 * FILE:
 *   sdl_ttf_font.hpp
 *
 * PURPOSE:
 *   Implementation of Font using SDL_TTF
 *
 * AUTHOR:
 *   Stephen Thompson, 2008
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 *   Note that to use this file in a working program you will need to
 *   link it to the SDL_TTF library which is LGPL.
 *
 */

#ifndef COERCRI_SDL_TTF_FONT_HPP
#define COERCRI_SDL_TTF_FONT_HPP

#include "../../gfx/font.hpp"
#include "../../gfx/color.hpp"

#include "SDL_ttf.h"
#include "boost/shared_ptr.hpp"
#include <iosfwd>

namespace Coercri {

    class SDLTTFFont : public Font {
    public:
        // "size" is the point size based on 72DPI -- which basically translates to pixel height.
        // NOTE: SDL_TTF may keep the file open and lazily load data
        // as needed. This is why the ifstream is passed in a
        // shared_ptr.
        SDLTTFFont(boost::shared_ptr<std::istream> str, int size);

        virtual void getTextSize(const std::string &text, int &w, int &h) const;
        virtual int getTextHeight() const;

        void drawText(GfxContext &dest, int x, int y, const std::string &text, Color col, bool antialias) const;
        
    private:
        boost::shared_ptr<TTF_Font> font;  // constructed with DeleteTTFFont
    };

}

#endif
