/*
 * FILE:
 *   sdl_graphic.hpp
 *
 * PURPOSE:
 *   Implementation of Graphic for SDL
 *
 * AUTHOR:
 *   Stephen Thompson, 2008
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 */

#ifndef COERCRI_SDL_GRAPHIC_HPP
#define COERCRI_SDL_GRAPHIC_HPP

#include "../../gfx/graphic.hpp"
#include "../../gfx/pixel_array.hpp"

#include "boost/shared_ptr.hpp"

#include "SDL.h"

namespace Coercri {

    class SDLGraphic : public Graphic {
    public:
        SDLGraphic(boost::shared_ptr<const PixelArray> pixels, int hx, int hy);

        void blit(SDL_Surface &dest, int x, int y) const;

        // overridden from Graphic:
        int getWidth() const;
        int getHeight() const;
        void getHandle(int &x, int &y) const;
        boost::shared_ptr<const PixelArray> getPixels() const;
        
    private:
        bool loadSurface() const;
        
    private:
        boost::shared_ptr<const PixelArray> pixels;
        int hx, hy;

        mutable boost::shared_ptr<SDL_Surface> surface;  // Constructed with DeleteSDLSurface
        mutable bool need_reload;
    };

}

#endif
