/*
 * FILE:
 *   sdl_gfx_driver.hpp
 *
 * PURPOSE:
 *   SDL implementation of GfxDriver
 *
 * AUTHOR:
 *   Stephen Thompson, 2008
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 */

#ifndef COERCRI_SDL_GFX_DRIVER_HPP
#define COERCRI_SDL_GFX_DRIVER_HPP

#include "../../gfx/gfx_driver.hpp"
#include "../core/sdl_subsystem_handle.hpp"

namespace Coercri {

    class SDLGfxDriver : public GfxDriver {
    public:
        // Constructor
        SDLGfxDriver();

        // Functions overridden from GfxDriver
        virtual DisplayModeVector getFullScreenModes();
        virtual DisplayMode getDesktopMode();
        virtual boost::shared_ptr<Window> createWindow(int width, int height,
                                                       bool resizable, bool fullscreen,
                                                       const std::string &title);
        virtual boost::shared_ptr<Graphic> createGraphic(boost::shared_ptr<const PixelArray> pixels, int hx = 0, int hy = 0);
        virtual bool pollEvents();
        virtual void setWindowsIcon(int resource_id);
        virtual void setKeyRepeat(bool enabled);
        
    private:
        SDLSubSystemHandle video_subsystem;
        int icon_id;
        DisplayMode desktop_mode;
    };
    
}

#endif
