/*
 * FILE:
 *   sdl_gfx_context.hpp
 *
 * PURPOSE:
 *   Implement GfxContext for SDL
 *
 * AUTHOR:
 *   Stephen Thompson, 2008
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 */

#ifndef COERCRI_SDL_GFX_CONTEXT_HPP
#define COERCRI_SDL_GFX_CONTEXT_HPP

#include "../../gfx/gfx_context.hpp"
#include "../../gfx/rectangle.hpp"

#include "SDL.h"

#include <stack>

namespace Coercri {

    class SDLGfxContext : public GfxContext {
    public:
        // Notes:
        // 1. Caller should ensure that the surface lives longer than the GfxContext
        // 2. Surface should be unlocked
        explicit SDLGfxContext(SDL_Surface &surf);
        virtual ~SDLGfxContext();

        virtual void setClipRectangle(const Rectangle &rect);
        virtual void clearClipRectangle();
        virtual Rectangle getClipRectangle() const;

        virtual int getWidth() const;
        virtual int getHeight() const;
        
        virtual void clearScreen(Color col);
        virtual void plotPixel(int x, int y, Color col);
        virtual void drawGraphic(int x, int y, const Graphic &graphic);
        virtual void drawText(int x, int y, const Font &font, const std::string &text, Color col, bool antialias);

        virtual void fillRectangle(const Rectangle &rect, Color col);

        // for those who want more low-level access:
        void lock();    // ensures surface is locked
        void unlock();  // ensures surface is unlocked
        SDL_Surface * getSurface() { return surface; }

    private:
        void loadClipRectangle();
        bool pointInClipRectangle(int x, int y) const;
        
    private:
        SDL_Surface *surface;
        bool locked;
        Rectangle clip_rectangle;
    };

}

#endif
