/*
 * FILE:
 *   delete_sdl_surface.hpp
 *
 * PURPOSE:
 *   Deleter for SDL_Surface - suitable for use with boost::shared_ptr
 *
 * AUTHOR:
 *   Stephen Thompson, 2008
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 */

#ifndef COERCRI_DELETE_SDL_SURFACE_HPP
#define COERCRI_DELETE_SDL_SURFACE_HPP

#include "SDL.h"

namespace Coercri {
    struct DeleteSDLSurface {
        void operator()(SDL_Surface *surf) {
            SDL_FreeSurface(surf);
        }
    };
}

#endif
