/*
 * FILE:
 *   sdl_subsystem_handle.hpp
 *
 * PURPOSE:
 *   RAII interface to initialization/shutdown of SDL and subsystems.
 *   Allows two different modules to use the same SDL subsystem
 *   without having to worry about it being deinitialized twice.
 *      
 * AUTHOR:
 *   Stephen Thompson, 2008
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 */

#ifndef COERCRI_SDL_SUBSYSTEM_HANDLE_HPP
#define COERCRI_SDL_SUBSYSTEM_HANDLE_HPP

namespace Coercri {

    class SDLSubSystemHandle {
    public:
        // Ctor will automagically initialize SDL (if necessary) and
        // initialize the relevant subsystem (if it hasn't already
        // been initialized). s should be one of the SDL_INIT_* flags
        // (or 0 if we only want to initialize SDL itself, without
        // initializing a subsystem).
        // NOTE: do not combine together multiple flags -- subsystems
        // should be initialized one at a time.
        explicit SDLSubSystemHandle(unsigned int s);

        // Copy constructor, etc. (Uses reference counting)
        SDLSubSystemHandle(const SDLSubSystemHandle &);
        SDLSubSystemHandle & operator=(const SDLSubSystemHandle &);
        ~SDLSubSystemHandle();
        
    private:
        unsigned int subsys;
        int *ref_count;
    };

}

#endif
