/*
 * FILE:
 *   istream_rwops.hpp
 *
 * PURPOSE:
 *   Provides an SDL_RWops for a C++ istream
 *
 * AUTHOR:
 *   Stephen Thompson, 2008
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 */

#ifndef COERCRI_ISTREAM_RWOPS_HPP
#define COERCRI_ISTREAM_RWOPS_HPP

#include "SDL.h"
#include "boost/shared_ptr.hpp"
#include <iosfwd>

namespace Coercri {
    // NOTE: The returned SDL_RWops must be freed in the usual way (by
    // calling SDL_RWclose).
    SDL_RWops * CreateRWOpsForIstream(boost::shared_ptr<std::istream> str);
}

#endif
