/*
 * FILE:
 *   window_listener.hpp
 *
 * PURPOSE:
 *   Interface for window events: close, gain/lose focus,
 *   keyboard/mouse input, etc.
 *
 * AUTHOR:
 *   Stephen Thompson, 2008.
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 */

#ifndef COERCRI_WINDOW_LISTENER_HPP
#define COERCRI_WINDOW_LISTENER_HPP

#include "key_code.hpp"
#include "mouse_button.hpp"

namespace Coercri {

    class GfxContext;
    class Region;
    class Window;
    
    class WindowListener {
    public:

        virtual ~WindowListener() { }
        
        // Window closed
        virtual void onClose() { }

        // Window gained or lost focus
        virtual void onGainFocus() { }
        virtual void onLoseFocus() { }

        // Window resized
        virtual void onResize(int new_width, int new_height) { }

        // Window minimized / un-minimized
        virtual void onActivate() { }
        virtual void onDeactivate() { }

        // Keyboard events

        // ke = KE_PRESSED, KE_AUTO_REPEAT or KE_RELEASED, see key_code.hpp
        // kc = key code, see key_code.hpp
        // character = unicode character value (if a printable char) or 0. generated only on KEY_PRESSED events.
        // modifiers = or'd combination of modifier values, see key_code.hpp.
        virtual void onKey(KeyEvent ke, KeyCode kc, int character, int modifiers) { }

        // Mouse button events
        virtual void onMouseDown(int x, int y, MouseButton button) { }
        virtual void onMouseUp(int x, int y, MouseButton button) { }

        // Mouse motion event
        virtual void onMouseMove(int new_x, int new_y) { }
    };

}

#endif
