/*
 * FILE:
 *   window.cpp
 *
 * AUTHOR:
 *   Stephen Thompson, 2008.
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 */

#include "window.hpp"

namespace Coercri {

    void Window::addWindowListener(WindowListener *wl)
    {
        listeners.push_back(wl);
    }

    void Window::rmWindowListener(WindowListener *wl)
    {
        for (std::vector<WindowListener*>::iterator it = listeners.begin(); it != listeners.end(); ++it) {
            if (*it == wl) {
                listeners.erase(it);
                break;
            }
        }
    }

    void Window::invalidateAll()
    {
        int w, h;
        getSize(w, h);
        invalid_region.clear();
        invalid_region.addRectangle(Rectangle(0, 0, w, h));
    }
}
