/*
 * FILE:
 *   ttf_loader.hpp
 *
 * PURPOSE:
 *   Interface for creating a Font from a TrueType file.
 *   (Implementation will be backend-specific.)
 *   
 * AUTHOR:
 *   Stephen Thompson, 2008
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 */

#ifndef COERCRI_TTF_LOADER_HPP
#define COERCRI_TTF_LOADER_HPP

#include "boost/shared_ptr.hpp"
#include <iosfwd>

namespace Coercri {
    class TTFLoader {
    public:
        
        // size is the point size at 72DPI (which is effectively pixel height).

        // NOTE: Implementations may keep hold of the istream and use
        // it to lazily load font data as needed. (E.g. SDL_TTF
        // appears to work this way.) Therefore we pass the istream as
        // a shared_ptr, rather than simply an istream&.
        
        virtual boost::shared_ptr<Font> loadFont(boost::shared_ptr<std::istream> str, int size) = 0;
    };
}

#endif
