/*
 * FILE:
 *   region.hpp
 *
 * PURPOSE:
 *   A Region is a list of non-overlapping rectangles
 *
 * AUTHOR:
 *   Stephen Thompson, 2008
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 */

#ifndef COERCRI_REGION_HPP
#define COERCRI_REGION_HPP

#include <vector>

namespace Coercri {

    class Rectangle;
    
    class Region {
    public:
        // Add rectangle. If an overlapping rectangle is added then it
        // will automatically be split up into multiple non-overlapping
        // rectangles.
        void addRectangle(const Rectangle &rect);

        // Add all rectangles from another region
        void addRegion(const Region &other);

        // Remove all rectangles
        void clear() { rectangles.clear(); }
        
        // Get smallest rectangle containing the whole region
        Rectangle getBoundingBox() const;

        // Iterator interface to loop over the constituent rectangles.
        // NOTE: All contained rectangles will be non-degenerate and
        // non-overlapping. No other guarantees are given.
        typedef std::vector<Rectangle>::const_iterator const_iterator;
        const_iterator begin() const { return rectangles.begin(); }
        const_iterator end() const { return rectangles.end(); }

        // Check whether the region is empty
        bool isEmpty() const { return rectangles.empty(); }
        
    private:
        // TODO: Should use a more efficient implementation, cf. X11
        // which represents a region as a list of horizontal "spans".
        std::vector<Rectangle> rectangles;
    };

}

#endif
