/*
 * FILE:
 *   pixel_array.hpp
 *
 * PURPOSE:
 *   2-D array of Color values, used to represent bitmap graphics in
 *   "device independent" form.
 *
 * AUTHOR:
 *   Stephen Thompson, 2008
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 */

#ifndef COERCRI_PIXEL_ARRAY_HPP
#define COERCRI_PIXEL_ARRAY_HPP

#include "color.hpp"

#include <vector>

namespace Coercri {

    class PixelArray {
    public:
        PixelArray(int w, int h) : data(w*h), width(w), height(h) { }

        int getWidth() const { return width; }
        int getHeight() const { return height; }

        Color& operator()(int x, int y) { return data[y*width + x]; }
        const Color& operator()(int x, int y) const { return data[y*width + x]; }

    private:
        std::vector<Color> data;
        int width, height;
    };

}

#endif
