/*
 * FILE:
 *   load_system_ttf.hpp
 *
 * PURPOSE:
 *   Load a TTF font from the system directories. We are given a list
 *   of font names, which are tried in order.
 *
 * NOTES:
 *   If USE_FONTCONFIG is defined this will use Fontconfig to locate
 *   the font files. Else if WIN32 is defined, fonts will be looked
 *   for in %WINDIR%\Fonts. Otherwise a compile time error will be
 *   generated currently.
 *   
 * AUTHOR:
 *   Stephen Thompson, 2008
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 */

#ifndef COERCRI_LOAD_SYSTEM_TTF_HPP
#define COERCRI_LOAD_SYSTEM_TTF_HPP

#include "boost/shared_ptr.hpp"

#include <string>
#include <vector>

namespace Coercri {

    class Font;
    class TTFLoader;

    // (size is point size at 72DPI, which is effectively pixel height)
    boost::shared_ptr<Font> LoadSystemTTF(TTFLoader &loader, const std::vector<std::string> &font_names, int size);
}

#endif
