/*
 * FILE:
 *   load_bmp.hpp
 *
 * PURPOSE:
 *   Load a PixelArray from a .BMP file.
 *
 * AUTHOR:
 *   Stephen Thompson, 2008
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 * NOTES:
 *   Coercri is not meant as an image loading library and so I haven't
 *   written many image loading routines, in fact there is only this
 *   one for BMPs, and it is a fairly basic one at that (it only
 *   supports the most common BMP formats). If you need better image
 *   loading routines then I suggest looking at other libraries e.g.
 *   DevIL or SDL_image.
 *
 */

#ifndef COERCRI_LOAD_BMP_HPP
#define COERCRI_LOAD_BMP_HPP

#include "boost/shared_ptr.hpp"
#include <iosfwd>

namespace Coercri {

    class PixelArray;

    boost::shared_ptr<PixelArray> LoadBMP(std::istream &str);

}

#endif
