/*
 * FILE:
 *   key_name.cpp
 *
 * AUTHOR:
 *   Stephen Thompson, 2008
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 */

#include "key_code.hpp"

#include <map>

namespace Coercri {
    
    namespace {
        std::map<KeyCode, const char *> names;

        void InitNames()
        {
            if (!names.empty()) return;
        
            names[KC_0] = "0";
            names[KC_1] = "1";
            names[KC_2] = "2";
            names[KC_3] = "3";
            names[KC_4] = "4";
            names[KC_5] = "5";
            names[KC_6] = "6";
            names[KC_7] = "7";
            names[KC_8] = "8";
            names[KC_9] = "9";
            names[KC_A] = "A";
            names[KC_AMPERSAND] = "&";
            names[KC_ASTERISK] = "*";
            names[KC_AT] = "@";
            names[KC_B] = "B";
            names[KC_BACKQUOTE] = "`";
            names[KC_BACKSLASH] = "\\";
            names[KC_BACKSPACE] = "BACKSPACE";
            names[KC_BREAK] = "BREAK";
            names[KC_C] = "C";
            names[KC_CAPS_LOCK] = "CAPS LOCK";
            names[KC_CARET] = "^";
            names[KC_CLEAR] = "CLEAR";
            names[KC_COLON] = ":";
            names[KC_COMMA] = ",";
            names[KC_COMPOSE] = "COMPOSE";
            names[KC_D] = "D";
            names[KC_DELETE] = "DELETE";
            names[KC_DOLLAR] = "$";
            names[KC_DOUBLE_QUOTE] = "\"";
            names[KC_DOWN] = "DOWN";
            names[KC_E] = "E";
            names[KC_END] = "END";
            names[KC_EQUALS] = "=";
            names[KC_ESCAPE] = "ESCAPE";
            names[KC_EURO] = "EURO";
            names[KC_EXCLAIM] = "!";
            names[KC_F] = "F";
            names[KC_F1] = "F1";
            names[KC_F2] = "F2";
            names[KC_F3] = "F3";
            names[KC_F4] = "F4";
            names[KC_F5] = "F5";
            names[KC_F6] = "F6";
            names[KC_F7] = "F7";
            names[KC_F8] = "F8";
            names[KC_F9] = "F9";
            names[KC_F10] = "F10";
            names[KC_F11] = "F11";
            names[KC_F12] = "F12";
            names[KC_F13] = "F13";
            names[KC_F14] = "F14";
            names[KC_F15] = "F15";
            names[KC_G] = "G";
            names[KC_GREATER] = ">";
            names[KC_H] = "H";
            names[KC_HASH] = "#";
            names[KC_HELP] = "HELP";
            names[KC_HOME] = "HOME";
            names[KC_I] = "I";
            names[KC_INSERT] = "INSERT";
            names[KC_J] = "J";
            names[KC_K] = "K";
            names[KC_KP_0] = "NUMPAD 0";
            names[KC_KP_1] = "NUMPAD 1";
            names[KC_KP_2] = "NUMPAD 2";
            names[KC_KP_3] = "NUMPAD 3";
            names[KC_KP_4] = "NUMPAD 4";
            names[KC_KP_5] = "NUMPAD 5";
            names[KC_KP_6] = "NUMPAD 6";
            names[KC_KP_7] = "NUMPAD 7";
            names[KC_KP_8] = "NUMPAD 8";
            names[KC_KP_9] = "NUMPAD 9";
            names[KC_KP_DIVIDE] = "NUMPAD /";
            names[KC_KP_ENTER] = "ENTER";
            names[KC_KP_EQUALS] = "NUMPAD =";
            names[KC_KP_MINUS] = "NUMPAD -";
            names[KC_KP_MULTIPLY] = "NUMPAD *";
            names[KC_KP_PERIOD] = "NUMPAD .";
            names[KC_KP_PLUS] = "NUMPAD +";
            names[KC_L] = "L";
            names[KC_LEFT] = "LEFT";
            names[KC_LEFT_ALT] = "LEFT ALT";
            names[KC_LEFT_BRACKET] = "[";
            names[KC_LEFT_CONTROL] = "LEFT CTRL";
            names[KC_LEFT_META] = "LEFT META";
            names[KC_LEFT_PAREN] = "LEFT (";
            names[KC_LEFT_SHIFT] = "LEFT SHIFT";
            names[KC_LEFT_SUPER] = "LEFT WINDOWS";
            names[KC_LESS] = "<";
            names[KC_M] = "M";
            names[KC_MENU] = "MENU";
            names[KC_MODE] = "MODE";
            names[KC_MINUS] = "-";
            names[KC_N] = "N";
            names[KC_NUM_LOCK] = "NUM LOCK";
            names[KC_O] = "O";
            names[KC_P] = "P";
            names[KC_PAGE_DOWN] = "PAGE DOWN";
            names[KC_PAGE_UP] = "PAGE UP";
            names[KC_PAUSE] = "PAUSE";
            names[KC_PERIOD] = ".";
            names[KC_PLUS] = "+";
            names[KC_POWER] = "POWER";
            names[KC_PRINT] = "PRINT SCREEN";
            names[KC_Q] = "Q";
            names[KC_QUESTION] = "?";
            names[KC_R] = "R";
            names[KC_RETURN] = "RETURN";
            names[KC_RIGHT] = "RIGHT";
            names[KC_RIGHT_ALT] = "RIGHT ALT";
            names[KC_RIGHT_BRACKET] = "]";
            names[KC_RIGHT_CONTROL] = "RIGHT CTRL";
            names[KC_RIGHT_META] = "RIGHT META";
            names[KC_RIGHT_PAREN] = ")";
            names[KC_RIGHT_SHIFT] = "RIGHT SHIFT";
            names[KC_RIGHT_SUPER] = "RIGHT WINDOWS";
            names[KC_S] = "S";
            names[KC_SCROLL_LOCK] = "SCROLL LOCK";
            names[KC_SEMICOLON] = ";";
            names[KC_SINGLE_QUOTE] = "'";
            names[KC_SLASH] = "/";
            names[KC_SPACE] = "SPACE";
            names[KC_SYSREQ] = "SYSREQ";
            names[KC_T] = "T";
            names[KC_TAB] = "TAB";
            names[KC_U] = "U";
            names[KC_UNDERSCORE] = "_";
            names[KC_UNDO] = "UNDO";
            names[KC_UP] = "UP";
            names[KC_V] = "V";
            names[KC_W] = "W";
            names[KC_X] = "X";
            names[KC_Y] = "Y";
            names[KC_Z] = "Z";
        }
    }

    std::string KeyName(KeyCode kc)
    {
        InitNames();
        std::map<KeyCode, const char *>::const_iterator it = names.find(kc);
        if (it == names.end()) {
            return "UNKNOWN";
        } else {
            return it->second;
        }
    }

}
