/*
 * FILE:
 *   graphic.hpp
 *
 * PURPOSE:
 *   "Device dependent" representation of a bitmap graphic
 *
 * AUTHOR:
 *   Stephen Thompson, 2008
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 */

#ifndef COERCRI_GRAPHIC_HPP
#define COERCRI_GRAPHIC_HPP

#include "boost/shared_ptr.hpp"

namespace Coercri {

    class PixelArray;
    
    class Graphic {
    public:
        virtual ~Graphic() { }

        virtual int getWidth() const = 0;
        virtual int getHeight() const = 0;
        virtual void getHandle(int &x, int &y) const = 0;
        virtual boost::shared_ptr<const PixelArray> getPixels() const = 0;
    };

}

#endif
