/*
 * FILE:
 *   gfx_context.hpp
 *
 * PURPOSE:
 *   Interface for drawing onto a Window
 *
 * AUTHOR:
 *   Stephen Thompson, 2008.
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 */

#ifndef COERCRI_GFX_CONTEXT_HPP
#define COERCRI_GFX_CONTEXT_HPP

#include "color.hpp"

#include <string>

namespace Coercri {

    class Font;
    class Graphic;
    class Rectangle;
    
    class GfxContext {
    public:
        // NOTE: If any "EndDrawing" type calls are required,
        // sub-classes should arrange for these to happen in the
        // destructor.
        virtual ~GfxContext() { }

        // Set/clear a clipping rectangle. This applies to all
        // graphics operations.
        virtual void setClipRectangle(const Rectangle &rect) = 0;
        virtual void clearClipRectangle() = 0;
        virtual Rectangle getClipRectangle() const = 0;

        // Get the total size of the target surface.
        virtual int getWidth() const = 0;
        virtual int getHeight() const = 0;
        
        // Drawing Functions
        virtual void clearScreen(Color col) = 0;   // (col.a is ignored)
        virtual void plotPixel(int x, int y, Color col) = 0;
        virtual void drawGraphic(int x, int y, const Graphic &graphic) = 0;
        virtual void drawText(int x, int y, const Font &font, const std::string &text, Color col, bool antialias) = 0;

        // The following have default implementations but can be
        // overridden if more efficient implementations are available.
        virtual void drawLine(int x1, int y1, int x2, int y2, Color col);
        virtual void drawRectangle(const Rectangle &rect, Color col);  // draws outline only.
        virtual void fillRectangle(const Rectangle &rect, Color col);  // draws a solid rectangle.
    };

}

#endif
