/*
 * FILE:
 *   font.hpp
 *
 * PURPOSE:
 *   Font interface
 *   
 * AUTHOR:
 *   Stephen Thompson, 2008
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 */

#ifndef COERCRI_FONT_HPP
#define COERCRI_FONT_HPP

#include "color.hpp"

#include <string>

namespace Coercri {

    class GfxContext;
    
    class Font {
    public:
        virtual ~Font() { }

        // Virtual functions
        virtual void drawText(GfxContext &dest, int x, int y, const std::string &text, Color col, bool antialias) const = 0;
        virtual int getTextHeight() const = 0;  // suggested spacing between text lines
        virtual void getTextSize(const std::string &text, int &w, int &h) const = 0;

        // Convenience function, if only width is required
        int getTextWidth(const std::string &text) const {
            int w,h;
            getTextSize(text,w,h);
            return w;
        }

    };

}

#endif
