/*
 * FILE:
 *   color.hpp
 *
 * PURPOSE:
 *   Struct representing an RGBA quadruple. Values range from 0 to 255.
 *
 * AUTHOR:
 *   Stephen Thompson, 2008
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 */

#ifndef COERCRI_COLOR_HPP
#define COERCRI_COLOR_HPP

namespace Coercri {

    struct Color {
        unsigned char r, g, b, a;

        Color() { r = g = b = 0; a = 255; }
        Color(unsigned char rr, unsigned char gg, unsigned char bb, unsigned char aa = 255)
            : r(rr), g(gg), b(bb), a(aa) { }
        
        bool operator<(const Color &other) const {
            return r < other.r ? true
                : r > other.r ? false
                : g < other.g ? true
                : g > other.g ? false
                : b < other.b ? true
                : b > other.b ? false
                : a < other.a;
        };
        bool operator==(const Color &other) const {
            return r==other.r && g==other.g && b==other.b && a==other.a;
        }
        bool operator!=(const Color &other) const {
            return !(*this == other);
        }
    };

}

#endif
