/*
 * FILE:
 *   bitmap_font.hpp
 *
 * PURPOSE:
 *   Simple class for drawing bitmap fonts.
 *
 * AUTHOR:
 *   Stephen Thompson, 2008
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 */

#ifndef COERCRI_BITMAP_FONT_HPP
#define COERCRI_BITMAP_FONT_HPP

#include "font.hpp"

#include "boost/shared_ptr.hpp"

namespace Coercri {

    class PixelArray;
    
    class BitmapFont : public Font {
    public:
        // NOTE: Alpha channel in the supplied PixelArray is ignored.
        explicit BitmapFont(boost::shared_ptr<PixelArray> pix);

        void getTextSize(const std::string &text, int &w, int &h) const;
        int getTextHeight() const;
        void drawText(GfxContext &dest, int x, int y, const std::string &text, Color col, bool antialias) const;

    private:
        boost::shared_ptr<PixelArray> pixels;
        int ofs[256];
        int width[256];
    };
}

#endif
