/*
 * FILE:
 *   cg_listener.hpp
 *
 * PURPOSE:
 *   WindowListener for handling a Guichan GUI. Collects
 *   mouse/keyboard input and handles rendering.
 *
 * AUTHOR:
 *   Stephen Thompson, 2008
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 */

#ifndef COERCRI_CG_LISTENER_HPP
#define COERCRI_CG_LISTENER_HPP

#include "../gfx/window_listener.hpp"

#include "boost/shared_ptr.hpp"

namespace gcn {
    class Gui;
}

namespace Coercri {

    class CGListenerImpl;
    class Timer;
    class Window;
    
    class CGListener : public WindowListener {
    public:
        // NOTE: Gui is disabled initially; make sure to call
        // enableGui() at some point!
        // NOTE: Caller must create the Gui (and add widgets to it)
        // but should not set the Input or Graphics as these are both
        // handled by CGListener.
        CGListener(boost::shared_ptr<Window> window,
                   boost::shared_ptr<gcn::Gui> gui,
                   boost::shared_ptr<Timer> timer);

        // Enable/disable the GUI
        // (This is useful for turning off all GUI processing without
        // having to actually remove the listener from the window.)
        // NOTE: Enabling while already enabled, or disabling while
        // already disabled, is harmless.
        void enableGui();
        void disableGui();
        bool isGuiEnabled() const;

        // This is to work around a bug in guichan
        void repeatLastMouseInput();
        
        // Access the underlying GUI object. Useful for e.g. setting
        // the top widget.
        gcn::Gui & getGUI();
        
        // processInput: If there is outstanding mouse or keyboard
        // input, then run Guichan logic() function, call
        // Window::invalidateAll(), and return true. Else do nothing
        // and return false.
        bool processInput();

        // This function draws the GUI. It should be called from the
        // main loop whenever the window is invalid.
        void draw(GfxContext &gc);
        
        // Overridden from WindowListener:
        virtual void onResize(int new_width, int new_height);
        virtual void onKey(KeyEvent ke, KeyCode kc, int character, int modifiers);
        virtual void onMouseDown(int x, int y, MouseButton button);
        virtual void onMouseUp(int x, int y, MouseButton button);
        virtual void onMouseMove(int x, int y);

    private:
        boost::shared_ptr<CGListenerImpl> pimpl;
    };

}

#endif
