/*
 * FILE:
 *   cg_input.hpp
 *
 * PURPOSE:
 *   Coercri implementation of gcn::Input. This just acts as a dumb
 *   container for Guichan KeyInputs and MouseInputs; these inputs are
 *   added by CGListener and removed by Guichan.
 *
 * AUTHOR:
 *   Stephen Thompson, 2008
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 */

#ifndef COERCRI_CG_INPUT_HPP
#define COERCRI_CG_INPUT_HPP

#include "../gfx/window_listener.hpp"

#include "guichan.hpp"

#include "boost/shared_ptr.hpp"

namespace Coercri {

    class Timer;
    
    class CGInput : public gcn::Input {
    public:

        // Constructor requires a Timer -- this is for the timestamps
        // in the guichan MouseInputs (which are used to check for
        // double clicks).
        explicit CGInput(boost::shared_ptr<Timer> tmr) : timer(tmr) { }
        
        // Functions from gcn::Input
        virtual bool isKeyQueueEmpty();
        virtual gcn::KeyInput dequeueKeyInput();
        virtual bool isMouseQueueEmpty();
        virtual gcn::MouseInput dequeueMouseInput();
        virtual void _pollInput() { }

        // Functions to add inputs.
        void addKeyInput(const gcn::KeyInput &);
        void addMouseInput(const gcn::MouseInput &);

        // Check if any input is waiting
        bool inputWaiting() const;
        
    private:
        boost::shared_ptr<Timer> timer;
        std::queue<gcn::KeyInput> key_inputs;
        std::queue<gcn::MouseInput> mouse_inputs;
    };
}

#endif
