/*
 * FILE:
 *   cg_input.cpp
 *
 * AUTHOR:
 *   Stephen Thompson, 2008
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 */

#include "cg_input.hpp"
#include "../timer/timer.hpp"

namespace Coercri {

    bool CGInput::isKeyQueueEmpty()
    {
        return key_inputs.empty();
    }

    gcn::KeyInput CGInput::dequeueKeyInput()
    {
        if (key_inputs.empty()) {
            throw GCN_EXCEPTION("Key input queue empty");
        }

        gcn::KeyInput k = key_inputs.front();
        key_inputs.pop();
        return k;
    }

    bool CGInput::isMouseQueueEmpty()
    {
        return mouse_inputs.empty();
    }
    
    gcn::MouseInput CGInput::dequeueMouseInput()    
    {
        if (mouse_inputs.empty()) {
            throw GCN_EXCEPTION("Mouse input queue empty");
        }

        gcn::MouseInput m = mouse_inputs.front();
        mouse_inputs.pop();
        return m;
    }

    void CGInput::addKeyInput(const gcn::KeyInput &ki)
    {
        key_inputs.push(ki);
    }

    void CGInput::addMouseInput(const gcn::MouseInput &mi)
    {
        mouse_inputs.push(mi);
    }


    bool CGInput::inputWaiting() const
    {
        return !key_inputs.empty() || !mouse_inputs.empty();
    }
    
}
