/*
 * FILE:
 *   cg_image.hpp
 *
 * PURPOSE:
 *   Coercri implementation of gcn::Image
 *   
 * AUTHOR:
 *   Stephen Thompson, 2008
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 */

#ifndef COERCRI_CG_IMAGE_HPP
#define COERCRI_CG_IMAGE_HPP

#include "guichan.hpp"

namespace Coercri {

    class Graphic;
    
    class CGImage : public gcn::Image {
    public:

        const Graphic & getGraphic() const;
        
        // Overriden from gcn::Image:
        virtual void free();
        virtual int getWidth() const;
        virtual int getHeight() const;
        virtual gcn::Color getPixel(int x, int y);
        virtual void putPixel(int x, int y, const gcn::Color &color);
        virtual void convertToDisplayFormat();
    };
}

#endif
