/*
 * FILE:
 *   cg_graphics.hpp
 *
 * PURPOSE:
 *   Coercri implementation of gcn::Graphics
 *
 * AUTHOR:
 *   Stephen Thompson, 2008
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 */

#ifndef COERCRI_CG_GRAPHICS_HPP
#define COERCRI_CG_GRAPHICS_HPP

#include "../gfx/color.hpp"

#include "guichan.hpp"

namespace Coercri {

    class GfxContext;
    
    class CGGraphics : public gcn::Graphics {
    public:
        CGGraphics() : gfx_context(0), curr_col(255,255,255) { }

        void setTarget(GfxContext *cxt) { gfx_context = cxt; }
        GfxContext * getTarget() const { return gfx_context; }
        
        virtual bool pushClipArea(gcn::Rectangle area);
        virtual void popClipArea();

        virtual void drawImage(const gcn::Image *image,
                               int srcX, int srcY,
                               int dstX, int dstY,
                               int width, int height);
        virtual void drawImage(const gcn::Image *image, int dstX, int dstY);

        virtual void drawPoint(int x, int y);
        
        virtual void drawLine(int x1, int y1, int x2, int y2);
        virtual void drawRectangle(const gcn::Rectangle &rectangle);
        virtual void fillRectangle(const gcn::Rectangle &rectangle);

        virtual void setColor(const gcn::Color &col);
        virtual const gcn::Color & getColor() const;
        // inherited: void setFont(Font *font)
        // inherited: void drawText(const string &text, int x, int y, Alignment alignment)

    private:
        void loadClipArea();
        Color getCoercriColor() const { return Color(curr_col.r, curr_col.g, curr_col.b, curr_col.a); }
        void transformPoint(int &x, int &y) const;
        
    private:
        GfxContext *gfx_context;
        gcn::Color curr_col;
    };
}

#endif
