/*
 * FILE:
 *   cg_font.hpp
 *
 * PURPOSE:
 *   Coercri implementation of gcn::Font
 *
 * AUTHOR:
 *   Stephen Thompson, 2008
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 */

#ifndef COERCRI_CG_FONT_HPP
#define COERCRI_CG_FONT_HPP

#include "../gfx/color.hpp"
#include "guichan.hpp"
#include "boost/shared_ptr.hpp"

namespace Coercri {

    class Font;

    class CGFont : public gcn::Font {
    public:
        // f must be non-null
        explicit CGFont(boost::shared_ptr<Coercri::Font> f, Color col = Color(255,255,255), bool aa = true)
            : font(f), color(col), antialias(aa) { }

        // guichan has no way to set text color or antialiasing, so
        // we will consider these to be a property of the font.
        Color getColor() const { return color; }
        void setColor(Color col) { color = col; }
        bool getAntiAlias() const { return antialias; }
        void setAntiAlias(bool aa) { antialias = aa; }

        // overridden from gcn::Font:
        virtual void drawString(gcn::Graphics *graphics, const std::string &text, int x, int y);
        virtual int getHeight() const;
        virtual int getWidth(const std::string &text) const;

    private:
        boost::shared_ptr<Coercri::Font> font;
        Color color;
        bool antialias;
    };

}

#endif
