/*
 * FILE:
 *   cg_font.cpp
 *
 * AUTHOR:
 *   Stephen Thompson, 2008
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 */

#include "cg_font.hpp"
#include "cg_graphics.hpp"
#include "../gfx/font.hpp"
#include "../gfx/gfx_context.hpp"

namespace Coercri {

    void CGFont::drawString(gcn::Graphics *graphics, const std::string &text, int x, int y)
    {
        CGGraphics * cg_gfx = dynamic_cast<CGGraphics*>(graphics);
        if (!cg_gfx) {
            throw GCN_EXCEPTION("CGFont can only be used with CGGraphics");
        }

        GfxContext * gfx_context = cg_gfx->getTarget();
        if (!gfx_context) {
            throw GCN_EXCEPTION("CGFont: missing gfx context");
        }

        const gcn::ClipRectangle & clip_area = graphics->getCurrentClipArea();
        
        gfx_context->drawText(clip_area.xOffset + x, clip_area.yOffset + y, *font, text, color, antialias);
    }

    int CGFont::getHeight() const
    {
        return font->getTextHeight();
    }

    int CGFont::getWidth(const std::string &text) const
    {
        return font->getTextWidth(text);
    }

}
