/*
 * FILE:
 *   enet_udp_socket.hpp
 *
 * PURPOSE:
 *   ENet implementation of UDPSocket
 *
 * AUTHOR:
 *   Stephen Thompson
 *
 * CREATED:
 *   14-Nov-2008
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 */

#ifndef COERCRI_ENET_UDP_SOCKET_HPP
#define COERCRI_ENET_UDP_SOCKET_HPP

#include "../network/udp_socket.hpp"

#include "enet/enet.h"

namespace Coercri {

    class EnetUDPSocket : public UDPSocket {
    public:
        explicit EnetUDPSocket(int port, bool reuseaddr);  // set port to -1 for unbound.
        virtual ~EnetUDPSocket();

        // send (to given address/port)
        void send(const std::string &address, int port, const std::string &msg);
        void broadcast(int port, const std::string &msg);

        // receive (on port set in ctor)
        bool receive(std::string &address, std::string &msg);
        
    private:
        ENetSocket sock;
        int bound_port;
    };

}

#endif
