/*
 * FILE:
 *   enet_network_driver.hpp
 *
 * PURPOSE:
 *   ENet implementation of NetworkDriver
 *
 * AUTHOR:
 *   Stephen Thompson, 2008
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 */

#ifndef COERCRI_ENET_NETWORK_DRIVER_HPP
#define COERCRI_ENET_NETWORK_DRIVER_HPP

#include "../network/network_driver.hpp"

#include "enet/enet.h"

namespace Coercri {

    class EnetNetworkConnection;

    class EnetNetworkDriver : public NetworkDriver {
    public:
        EnetNetworkDriver(int max_incoming, int max_outgoing);   // max no of peers in each direction.
        virtual ~EnetNetworkDriver();
        
        virtual boost::shared_ptr<NetworkConnection> openConnection(const std::string &host, int port);
        virtual void setServerPort(int port);
        virtual void enableServer(bool enabled);
        virtual Connections pollIncomingConnections();
        virtual bool doEvents();
        virtual bool outstandingConnections();
        
        virtual boost::shared_ptr<UDPSocket> createUDPSocket(int port, bool reuseaddr);

        virtual std::string resolveAddress(const std::string &ip_address);        
        
    private:
        bool serviceHost(ENetHost *host);
        void createIncomingHostIfNeeded();
        void destroyIncomingHost();
        
    private:
        static bool is_enet_initialized;   // Don't allow more than one enet instance at the same time.

    private:
        ENetHost *incoming_host, *outgoing_host;
        int server_port;
        bool server_enabled;
        int max_incoming;
        typedef std::vector<boost::shared_ptr<EnetNetworkConnection> > EnetConnections;
        EnetConnections connections_out;
        EnetConnections connections_in;
        Connections new_connections_in;
    };

}

#endif
