/*
 * FILE:
 *   enet_network_connection.hpp
 *
 * PURPOSE:
 *   ENet implementation of NetworkConnection
 *
 * AUTHOR:
 *   Stephen Thompson, 2008
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 */

#ifndef COERCRI_ENET_CONNECTION_HPP
#define COERCRI_ENET_CONNECTION_HPP

#include "../network/network_connection.hpp"

#include "enet/enet.h"

#include <queue>

namespace Coercri {

    class EnetNetworkConnection : public NetworkConnection {
    public:
        // ctor for outgoing connections
        EnetNetworkConnection(ENetHost *host, const std::string &hostname, int port);

        // ctor for incoming connections
        explicit EnetNetworkConnection(ENetPeer *peer_);

        // dtor -- resets the connection and severs link with ENetPeer
        ~EnetNetworkConnection();

        // Overridden from base class:
        virtual State getState() const;
        virtual void close();
        virtual void send(const std::vector<unsigned char> &);
        virtual void receive(std::vector<unsigned char> &);
        virtual std::string getAddress();
        
        // Functions called by EnetNetworkDriver:
        void onReceiveAcknowledgment();
        void onReceivePacket(ENetPacket *packet);
        void onDisconnect();
        
    private:
        // NOTE: if state is CLOSED but peer!=0 this means we have sent our enet_peer_disconnect msg, but
        // haven't received the DISCONNECT event yet. No further transmits should be attempted in this case.
        ENetPeer *peer;
        State state;
        std::queue<ENetPacket*> queued_packets;  // incoming packets
        std::queue<std::vector<unsigned char> > outgoing_packets;   // waiting to be transmitted when we go from PENDING to CONNECTED
    };

}

#endif
