/*
 * FILE:
 *   coercri_error.hpp
 *
 * PURPOSE:
 *   Base class for exceptions thrown by the Coercri library
 *
 * AUTHOR:
 *   Stephen Thompson, 2008
 *
 * COPYRIGHT:
 *   Usage of this file is permitted under the terms of the Boost
 *   Software License, version 1.0.
 *
 */

#ifndef COERCRI_ERROR_HPP
#define COERCRI_ERROR_HPP

#include <exception>
#include <string>

namespace Coercri {

    class CoercriError : public std::exception {
    public:
        explicit CoercriError(const std::string &m) : msg(m) { }
        ~CoercriError() throw() { }
        virtual const char * what() const throw() { return msg.c_str(); }
    private:
        std::string msg;
    };

}

#endif
