/*
 * client_config.hpp
 *
 * Holds the graphics, anims etc used during a game. These would have
 * been sent to us by the server.
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#ifndef CLIENT_CONFIG_HPP
#define CLIENT_CONFIG_HPP

#include "menu.hpp"

#include "boost/noncopyable.hpp"
#include "boost/scoped_ptr.hpp"
#include <vector>

class Anim;
class Graphic;
class Overlay;
class Sound;
class UserControl;

class ClientConfig : boost::noncopyable {
public:
    ClientConfig() : approach_offset(0) { }
    ~ClientConfig();   // calls delete on all the stored ptrs.
    
    std::vector<const Graphic*> graphics;
    std::vector<const Anim*> anims;
    std::vector<const Overlay*> overlays;
    std::vector<const Sound*> sounds;
    std::vector<const UserControl*> standard_controls;
    std::vector<const UserControl*> other_controls;
    boost::scoped_ptr<Menu> menu;
    int approach_offset;
};

#endif
