/*
 * client_config.cpp
 *
 * Copyright (c) Stephen Thompson, 2009.
 * Licensed for non-commercial use only. See LICENCE.txt for details.
 *
 */

#include "misc.hpp"

#include "client_config.hpp"

#include "anim.hpp"
#include "user_control.hpp"
#include "graphic.hpp"
#include "overlay.hpp"
#include "sound.hpp"

namespace {
    template<class T>
    void DeleteAll(std::vector<const T*> &x)
    {
        for (typename std::vector<const T*>::iterator it = x.begin(); it != x.end(); ++it) {
            delete *it;
        }
    }
}

ClientConfig::~ClientConfig()
{
    DeleteAll(graphics);
    DeleteAll(anims);
    DeleteAll(overlays);
    DeleteAll(sounds);
    DeleteAll(standard_controls);
    DeleteAll(other_controls);
}
