#include <unistd.h>

#include "test.h"

int main() {
    g_thread_init (NULL);
    g_type_init();
    {
        TEST_INFO (Test attributes on "http://www.example.com/index.html");
        URL u ("http://www.example.com/index.html");
        TEST_VERIFY (u.protocol() == "http" );
        debugLog() << u.path() << endl;
        TEST_VERIFY (u.path() == "/index.html" );
    }
    {
        TEST_INFO (Test common schemes);
        URL u ("mms://www.example.com:8080");
        TEST_VERIFY (u.protocol() == "mms" );
        u = URL ("rtsp://www.example.com");
        TEST_VERIFY (u.protocol() == "rtsp" );
        u = URL ("https://www.example.com");
        TEST_VERIFY (u.protocol() == "https" );
        u = URL ("file:///tmp");
        TEST_VERIFY (u.protocol() == "file" );
    }
    {
        TEST_INFO (Test attributes of urltest.cpp);
        URL u (File ("urltest.cpp"));
        TEST_VERIFY (u.isLocalFile() == true );
        debugLog() << u.url() << endl;
        TEST_VERIFY (u.url() == "file:///home/koos/kmplayer/trunk/test/urltest.cpp" );
        TEST_VERIFY (u.path() == "/home/koos/kmplayer/trunk/test/urltest.cpp" );
        TEST_VERIFY (!strncmp ("text/", GMimeType::findByURL (u), 5));
    }
    {
        TEST_INFO (Test HTML mimetype);
        File f ("bar.txt");
        f.open (IO_WriteOnly);
        f.writeBlock ("<html><body>Hi there</body></html>", 34);
        f.close ();
        TEST_VERIFY (strcmp ("text/html", GMimeType::findByURL (URL (f))));
        unlink ("bar.txt");
    }
    {
        TEST_INFO (Test /bin/ls mimetype);
        File f ("/bin/ls");
        TEST_VERIFY (strncmp ("text/", GMimeType::findByURL (URL (f)), 5));
    }
    {
        TEST_INFO (Test /home/koos/MyDocs/.videos/video1.mpg attributes);
        URL u ("/home/koos/MyDocs/.videos/video1.mpg");
        TEST_VERIFY (!strncmp ("video/", GMimeType::findByURL (u), 6));
        TEST_VERIFY (u.isLocalFile() == true );
    }
    {
        TEST_INFO (Test /bin/ls mimetype);
        File f ("/bin/ls");
        debugLog() << "mimetype: " << GMimeType::findByURL (URL (f)) << endl;
        TEST_VERIFY (strncmp ("text/", GMimeType::findByURL (URL (f)), 5));
    }
    {
        TEST_INFO (Test URL::encode_string "this is a test");
        TEST_VERIFY (URL::encode_string ("this is a test") == "this%20is%20a%20test");
        TEST_VERIFY (URL::decode_string ("this%20is%20a%20test") == "this is a test");
    }
    {
        TEST_INFO (Test index.php relative to "http://www.example.com/index.html");
        URL u (URL ("http://www.example.com/index.html"), "index.php");
        TEST_VERIFY (u.url () == "http://www.example.com/index.php");
        debugLog() << u.url () << endl;
    }
    {
        TEST_INFO (Test "/index.php" relative to "http://www.example.com");
        URL u (URL ("http://www.example.com"), "/index.php");
        TEST_VERIFY (u.url () == "http://www.example.com/index.php");
    }
    {
        TEST_INFO (Test index.php relative to "http://www.example.com/");
        URL u (URL ("http://www.example.com/"), "index.php");
        TEST_VERIFY (u.url () == "http://www.example.com/index.php");
    }
    {
        TEST_INFO (Test index.php relative to "http://www.example.com/data/");
        URL u (URL ("http://www.example.com/data/"), "index.php");
        TEST_VERIFY (u.url () == "http://www.example.com/data/index.php");
    }
    {
        TEST_INFO (Test "/index.php" relative to "http://www.example.com/data/");
        URL u (URL ("http://www.example.com/data/"), "/index.php");
        TEST_VERIFY (u.url () == "http://www.example.com/index.php");
    }
    {
        TEST_INFO (Test "http://www.example.com/index.php" relative to "http://www.example.com/index.html");
        URL u (URL ("http://www.example.com/index.html"), "http://www.example.com/index.php");
        TEST_VERIFY (u.url () == "http://www.example.com/index.php");
    }
    return 0;
}
