#include <unistd.h>

#include "test.h"

int main() {
    g_thread_init (NULL);
    g_type_init();
    {
        TEST_INFO (Test non existence of file);
        File f ("foo.txt");
        TEST_VERIFY (f.exists() == false );
    }
    {
        TEST_INFO (Test existence of file);
        File f ("filetest.cpp");
        TEST_VERIFY (f.exists() == true );
    }
    {
        TEST_INFO (Test writing 14 bytes to file);
        File f ("bar.txt");
        f.open (IO_WriteOnly);
        f.writeBlock ("This is a test", 14);
        f.close ();
        TEST_VERIFY (f.exists() == true );
        TEST_VERIFY (f.size() == 14 );
        unlink ("bar.txt");
    }
    {
        TEST_INFO (Test writing 5 times 14 bytes to file);
        File f ("bar.txt");
        f.open (IO_WriteOnly);
        for (int i = 0; i < 5; ++i)
            f.writeBlock ("This is a test", 14);
        f.close ();
        TEST_VERIFY (f.exists() == true );
        TEST_VERIFY (f.size() == 5 * 14 );
        unlink ("bar.txt");
    }
    {
        TEST_INFO (Test writing 5 times 14 bytes to file and read all back);
        File f ("bar.txt");
        f.open (IO_WriteOnly);
        for (int i = 0; i < 5; ++i)
            f.writeBlock ("This is a test", 14);
        f.close ();
        ByteArray ba = f.readAll();
        TEST_VERIFY (ba.size() == 5 * 14 );
        unlink ("bar.txt");
    }
    {
        TEST_INFO (Test writing 14 bytes to file and read all in new file);
        File f ("bar.txt");
        f.open (IO_WriteOnly);
        f.writeBlock ("This is a test", 14);
        f.close ();
        File g ("bar.txt");
        ByteArray ba = g.readAll();
        TEST_VERIFY (ba.size() == 14 );
        unlink ("bar.txt");
    }
    {
        TEST_INFO (Test readAll rewinding after writing);
        File f ("bar.txt");
        f.open (IO_WriteOnly);
        f.writeBlock ("This is a test", 14);
        ByteArray ba = f.readAll();
        TEST_VERIFY (ba.size() == 14 );
        unlink ("bar.txt");
    }
    return 0;
}
