/*
 * Copyright (C) 2008-2009 Petrozavodsk State University
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
#define CTF_LOG_FORMAT_USE_TIME
#define CTF_THROW_EXIT

#include "events/events.h"
#include "../CTF/src/ctf.h"
#include <ui/callbacks.h>
#include <settings/settings.h>
#include <appdata.h>
#include <time.h>

#define BUF_SIZE 2048

GLOBAL_DECL();
CTF_TEST_DATA_FILE_NAME_DECL;
CTF_STAT_FILE_NAME_DECL;

CTF_TEST_CASE(period_test) {
    CTF_TEST_NAME("period_test");

    AppData   *data;
    data = create_data();
    conf_init(data);

    ev_db_date_id_list_free(data);

    event* ev = ev_mgr_new(NULL);
    ev->start_time = time(NULL);
    ev_mgr_rt_to_period(REPEAT_MON_WED_FRI, ev);
    CTF_CHECK_MSG(ev->per->n_days == 3, "Check REPEAT_MON_WED_FRI failed");
    ev_mgr_clear(ev, NULL);

    ev = ev_mgr_new(NULL);
    ev->start_time = time(NULL);
    ev_mgr_rt_to_period(REPEAT_TUE_THU, ev);
    CTF_CHECK_MSG(ev->per->n_days == 2, "Check REPEAT_TUE_THU failed");
    ev_mgr_clear(ev, NULL);
   

    ev_mgr_rt_to_period(REPEAT_MON_WED_FRI, ev);

    int i;
    for(i = REPEAT_UNSET; i < REPEAT_OTHER; i++) {
        ev = ev_mgr_new(NULL);
        ev->start_time = time(NULL);
        ev_mgr_rt_to_period(i, ev);
        
        const char msg[BUF_SIZE];
        sprintf(msg, "Check conversion RepeatType -> period -> RepeatType failed with i = %d", i);

        CTF_CHECK_MSG(ev_mgr_period_to_rt(ev) == i, msg);
        
        ev_mgr_clear(ev, NULL);
    }
    
    ev_db_date_id_list_free(data);
    destroy_data(data);
}



