/*
 * Copyright (C) 2008-2009 Petrozavodsk State University
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
#define CTF_LOG_FORMAT_USE_TIME
#define CTF_THROW_EXIT

#include "events/events.h"
#include "../CTF/src/ctf.h"
#include <ui/callbacks.h>
#include <settings/settings.h>
#include <appdata.h>
#include <time.h>

GLOBAL_DECL();
CTF_TEST_DATA_FILE_DECL;
CTF_STAT_FILE_NAME_DECL;

CTF_TEST_CASE(new_event_test) 
{
    CTF_TEST_NAME("new_event_test");
    AppData   *data;
    int       i;

    data = create_data();
    conf_init(data);

    GError *err = NULL;
    event *ev = ev_mgr_new(&err);

    if(err) g_error_free(err);
    
    CTF_CHECK(ev->id == 0 
            && ev->id_type == 0
            && ev->title == NULL
            && ev->description == NULL
            && ev->per == NULL
            && ev->start_time == 0
            && ev->end_time == 0
            && ev->location == NULL
            && ev->remind == NULL);

    err = NULL;
    ev_mgr_clear(ev, &err);
    if(err) g_error_free(err);
   


    err = NULL;
    ev = ev_mgr_new(&err);
    if(err) g_error_free(err);

    
    ev->title = malloc(256);
    ev->location = malloc(256);

    err = NULL;
    ev_mgr_clear(ev, &err);
    if(err) g_error_free(err);
    
    
    destroy_data(data);
}

CTF_TEST_CASE(store_event_test)
{
   srand(time(NULL));
   CTF_TEST_NAME("store_event_test");
   AppData   *data;
   int       i;

   data = create_data();
   conf_init(data);

   GError *err = NULL;
   event *ev = ev_mgr_new(&err);
   if(err) g_error_free(err);

   ev->id_type = 1;

   char title[512];
   sprintf(title, "testestesfkkksd90435849%d0843985438uudiuiui" , rand());
   
   ev->title = malloc(strlen(title) + 1);
   strcpy(ev->title, title);

   const char *location = "tesqqqqqqqqqqqqqqqqqqqqqqqqsssssssssssssssssssssssss"
       "szzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzzztestesfkkksd904358490843985438uu"
       "diuiui";
   ev->location = malloc(strlen(location) + 1);
   strcpy(ev->location, location);

   const char *description = "43985438uudiuiui";
   ev->description = malloc(strlen(description) + 1);
   strcpy(ev->description, description);

   ev->start_time = time(NULL);
   ev->end_time = time(NULL) + 3600;
   
   //Запись события в бд
   err = NULL;
   ev_mgr_store(ev, data, &err);
   if(err) g_error_free(err);

   int id = ev->id;
   
   err = NULL;
   ev_mgr_clear(ev, &err);
   if(err) g_error_free(err);

   //Поиск события в базе данных
   err = NULL;
   ev_sel_get_by_period(time(NULL) - 3600 * 48, time(NULL) + 3600 * 48, data, &err);
   if(err) g_error_free(err);
   
   err = NULL;
   GPtrArray* arr =  ev_sel_filter(data, data->id_list, "zzzzzzzzzzzzzzzzzzt", &err);
   if(err) g_error_free(err);

   
   int ok = 0;
   for (i = 0; i < arr->len; i++) {
       ev = g_ptr_array_index(arr, i);
       if (!strcmp(ev->title, title)) {
           ok = 1;
           break;
       }
   }
   CTF_CHECK(ok);
   CTF_CHECK(id == ev->id);
   ev_sel_event_array_free(arr);

   ev_db_date_id_list_free(data);
   CTF_CHECK(data->id_list == NULL);

   //Повторный поиск события в базе данных
   if(ok) {
       err = NULL;
       ev_mgr_remove(id, data, &err);
       if(err) g_error_free(err);


       err = NULL;
       ev_sel_get_by_period(time(NULL) - 3600 * 48, time(NULL) + 3600 * 48, data, &err);
       if (err) g_error_free(err);

       err = NULL;
       GPtrArray* arr =  ev_sel_filter(data, data->id_list, "zzzzzzzzzzzzzzzzzzt", &err);
       if (err) g_error_free(err);

       ok = 0;
       for (i = 0; i < arr->len; i++) {
           ev = g_ptr_array_index(arr, i);
           if (!strcmp(ev->title, title)) {
               ok = 1;
               break;
           }
       }
   }
   CTF_CHECK(!ok);

   ev_db_date_id_list_free(data);
   CTF_CHECK(data->id_list == NULL);

   destroy_data(data);
}

CTF_TEST_CASE(store_event_test2)
{
    CTF_TEST_NAME("store_event_test2");
    AppData   *data;
    int       i;

    data = create_data();
    conf_init(data);

    event* ev = ev_mgr_new(NULL);
    ev->title = calloc(1000000, sizeof(char));
    for (i = 0; i < 1000000 - 1; i++) {
        ev->title[i] = rand() % 254 + 1;
    }

    GError* err = NULL;

    ev_mgr_store(ev, data, &err);
    CTF_CHECK_MSG(!err, "Event with very long (1M) fields");
    
    if (err) {
        g_error_free(err);
    }
    ev_mgr_remove(ev->id, data, NULL);
    ev_mgr_clear(ev, NULL);
    destroy_data(data);
}

CTF_TEST_CASE(store_event_test3)
{
    CTF_TEST_NAME("store_event_test3");
    AppData   *data;
    int       i;
    data = create_data();
    conf_init(data);

    event* ev = ev_mgr_new(NULL);
    ev->title = calloc(100, sizeof(char));
    sprintf(ev->title, "%s", "store_event3_test3");
    ev_mgr_store(ev, data, NULL);
    int id = ev->id;
    ev_mgr_clear(ev, NULL);

    ev = ev_mgr_new(NULL);
    ev_sel_get_by_id(id, ev, data, NULL);

    CTF_CHECK_MSG(ev->description && ev->location && ev->title, "ev_sel_get_by_id return NULL in location or title");
    ev_mgr_remove(id, data, NULL);
    ev_mgr_clear(ev, NULL);

    destroy_data(data);
}

CTF_TEST_CASE(ev_sel_get_next_in_period_test2)
{   
    CTF_TEST_NAME("ev_sel_get_next_in_period_test2");
    AppData *data;
    int i, j;
    data = create_data();
    conf_init(data);

    event* ev = ev_mgr_new(data);

    ev->start_time = 1253836801; //25.09.2009 00:00
    ev_mgr_rt_to_period(REPEAT_MON_WED_FRI, ev);
    ev->per->end_time = 1259107201; //25.11.2009 00:01
    ev_mgr_store(ev, data, NULL);
    
    int id = ev->id;
    ev_sel_get_by_period(315532801 /* 1.1.1980 */, 2051222401 /* 1.1.2035 */,
                    data, NULL);
    for (i = 0; data->id_list[i].date > 0; i++) {
        for (j = 0; j < data->id_list[i].ids_size; j++) {
            if (data->id_list[i].ids[j] == id &&  data->id_list[i].date > 1259107201) {
                CTF_CHECK(0);
            }
        }
    }

    ev_mgr_remove(id, data, NULL);
    ev_db_date_id_list_free(data);
    ev_mgr_clear(ev, NULL);
    destroy_data(data);
}

CTF_TEST_CASE(ev_sel_get_next_in_period_test)
{
    CTF_TEST_NAME("ev_sel_get_next_in_period");
    AppData* data;
    int i;
    data = create_data();
    conf_init(data);

    GDate event_start;
    g_date_clear(&event_start, 1);
    g_date_set_dmy(&event_start, 15, G_DATE_JUNE, 2004);

    GDate start;
    g_date_clear(&start, 1);

    g_date_set_dmy(&start, 15, G_DATE_JUNE, 2004);
    ev_sel_get_next_in_period(&event_start, &start, 3, 1);
    CTF_CHECK(g_date_get_day(&start) == 1 && g_date_get_month(&start) == 6 && g_date_get_year(&start) == 2004);
    
    g_date_set_dmy(&start, 1, G_DATE_JUNE, 2004);
    ev_sel_get_next_in_period(&event_start, &start, 1, 4);
    CTF_CHECK(g_date_get_day(&start) == 3 && g_date_get_month(&start) == 6 && g_date_get_year(&start) == 2004);
   
    g_date_set_dmy(&start, 1, G_DATE_JULY, 2004);
    ev_sel_get_next_in_period(&event_start, &start, 3, 12);
    CTF_CHECK(g_date_get_day(&start) == 1 && g_date_get_month(&start) == 6 && g_date_get_year(&start) == 2005);
 
    g_date_set_dmy(&start, 23, G_DATE_JUNE, 2004);
    ev_sel_get_next_in_period(&event_start, &start, 2, 2);
    CTF_CHECK(g_date_get_day(&start) == 28 && g_date_get_month(&start) == 6 && g_date_get_year(&start) == 2004);

    destroy_data(data);
}
