/*
 * Copyright (C) 2008-2009 Petrozavodsk State University
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
/* ========================================================================== */
/* Events data select subsystem source file.                                  */
/*                                                                            */
/* Author: Kovalev V., Petrozavodsk State University                          */
/* Author: Ivashov K., Petrozavodsk State University                          */
/* Date  : 2/09/2009                                                         */
/* ========================================================================== */
#include <events/events.h>

int ev_sel_get_by_id(const int id, event* ev, AppData* app_data, 
        GError** error) 
{
    GPtrArray* results;
    int entries, cols;

    if (app_data == NULL || ev == NULL) { 
        return -1;
    }

    /* 1. Call EventDataAccess module to perform this query */
    if ((results = ev_db_sql_query_prep_str(app_data->db_data.get_by_id, &entries, &cols, app_data, error, DB_INT, id, DB_END)) == NULL) {
        return -1;
    }
    char** string = g_ptr_array_index(results ,0);
#if 0
    int i;
    g_debug("Get event with id=%d\n", id);

    for (i = 0; i < cols; i++) {
        g_debug("%s\n", string[i] != NULL ? string[i] : "(null)");
    }
#endif
    /* 2. Set ev parameter according to the result */
    ev->id = atoi(string[0]);

    if (string[1]) {
        ev->id_type = atoi(string[1]);
    }

    if (string[2]) {
        if ((ev->title = malloc(strlen(string[2]) + 1)) == NULL) {
            g_set_error(error, EV_SEL_ERROR, EV_SEL_ALLOCATE_ERROR, "Failed allocate");
            ev_db_sql_query_clear_2(results, cols);

            return -1;
        }
        strcpy(ev->title, string[2]);
    }
    else {
        ev->title = malloc(strlen("") + 1);
        strcpy(ev->title, "");
    }


    if (string[3])
        ev->start_time = atoi(string[3]);

    if (string[4])
        ev->end_time = atoi(string[4]);

    if (string[5]) {
        if ((ev->description = malloc(strlen(string[5]) + 1)) == NULL) {
            g_set_error(error, EV_SEL_ERROR, EV_SEL_ALLOCATE_ERROR, "Failed allocate");
            ev_db_sql_query_clear_2(results, cols);

            return -1;
        }
        strcpy(ev->description, string[5]);
    }
    else {
        ev->description = malloc(strlen("") + 1);
        strcpy(ev->description, "");
    }

    ev->per = NULL;
    if (string[11]) {
        int per_type = atoi(string[11]);
        if (per_type) {
            /* Day array */
            period *per = calloc(1, sizeof(period));

            if (string[9]) {
                GArray *days = NULL; /* Days array */

                gchar **daysc = g_strsplit(string[9], ",", 128); /* Split string to days */

                days = g_array_new(FALSE, FALSE, sizeof(int));
                int k;
                for (k = 0; daysc[k]; k++) {
                    int day = atoi(daysc[k]);
                    g_array_append_val(days, day);
                }
                per->n_days = days->len;
                per->days = (int*) g_array_free(days, FALSE);
                g_strfreev(daysc);

            }
            per->type = per_type;

            if (string[7])
                per->start_time = atoi(string[7]);

            if (string[8])
                per->end_time = atoi(string[8]);

            if (string[10])
                per->repeat = atoi(string[10]);

            ev->per = per;
        }
    }

    if (string[12]) {
        if ((ev->location = malloc(strlen(string[12]) + 1)) == NULL) {
            g_set_error(error, EV_SEL_ERROR, EV_SEL_ALLOCATE_ERROR, "Failed allocate");
            ev_db_sql_query_clear_2(results, cols);

            return -1;
        }
        strcpy(ev->location, string[12]);
    }
    else {
        ev->location = malloc(strlen("") + 1);
        strcpy(ev->location, "");
    }



    if (string[6])
        ev->remind = atoi(string[6]);

    if (string[13])
        ev->alarm_cookie = atoi(string[13]);

    if (string[14]) {
        if ((ev->service_event_id = malloc(strlen(string[14]) + 1)) == NULL) {
            g_set_error(error, EV_SEL_ERROR, EV_SEL_ALLOCATE_ERROR, "Failed allocate");
            ev_db_sql_query_clear_2(results, cols);

            return -1;
        }
        strcpy(ev->service_event_id, string[14]);
    }

    /* 3. Call EventDataAccess to clear query results */
    ev_db_sql_query_clear_2(results, cols);

    return 0;
}

int ev_sel_get_by_period(const time_t start, const time_t end, 
        AppData* app_data, GError** error) 
{
    GPtrArray* result;
    int entries, cols;

    if (app_data == NULL) { 
        return -1;
    }

    /* 0. Create an SQL query to get events by period */
    //snprintf(query, MAX_QUERY, "SELECT id FROM tblEvent");
    /* 1. Call EventDataAccess module to perform this query */
    //if((results = ev_db_sql_query_str(query, &entries, &cols, app_data, error)) == NULL) {
    //    return -1;
    //}
    result = ev_db_sql_query_prep_str(app_data->db_data.get_period, &entries, &cols, app_data, error, DB_END);
    /* 2. Analyze query results using specified algorithm (see wiki) */
    ev_db_pereodic_analyze(result, start, end, &entries, &cols, app_data);
    /* 3. Set date_id_list parameter according to the results */
    /* 
    ev_db_date_id_list_alloc(app_data->id_list, entries, 1);
    if(app_data->id_list == NULL) {
        return -1;
    }
    for(i = 0; i < entries; ++i) {
        app_data->id_list[i].date = atoi(results[i][1]);
        app_data->ids[0] = atoi(results[i][0]);
    }
    */

    /* 4. Call EventDataAccess to clear query results */
    ev_db_sql_query_clear_2(result, cols);

    return 0;
}
void ev_sel_event_array_free(GPtrArray* arr)
{
    int i;
    for (i = 0; i < arr->len; i++) {
        ev_mgr_clear(g_ptr_array_index(arr, i), NULL);
        //free(g_ptr_array_index(arr, i));
    }
    g_ptr_array_free(arr, TRUE);
}

GPtrArray* ev_sel_filter(AppData* app, date_id_list* dil, const char* filter, GError** err)
{
    /* 0. Create an SQL auery to get all events whose IDs are in yhe dil list */
    /* 1. For each event in result check whether string filter can be applied 
     * to one of the fields                                                   */
    /* 2. Fill dil parameter according to the result                          */
    /* 3. Call EventDataAccess to clear query results       */

    int i, j, k;
    /* Result array */
    GPtrArray* arr = g_ptr_array_new();

    /*  identifiers, that has been checked */
    GArray* id_arr = g_array_new(FALSE, FALSE, sizeof(int));

    char* filter_low =  g_utf8_strdown(filter, -1);
    for (i = 0; dil[i].date > 0; i++) { /* Dates in id_list */
        for (j = 0; j < dil[i].ids_size; j++) {
            int id = dil[i].ids[j];
            int found = 0;
            for (k = 0; k < id_arr->len; k++) { /* if id has already checked, then skip */
                if (id == g_array_index(id_arr, int, k)) {
                    found = 1;
                    break;
                }
            }
            /* id hasn't checked */
            if (!found) {
                g_array_append_val(id_arr, id);

                event *ev = ev_mgr_new(NULL);

                ev_sel_get_by_id(id, ev, app, NULL);
                char* title = g_utf8_strdown(ev->title, -1);
                char* desc  = g_utf8_strdown(ev->description, -1);
                char* loc   = g_utf8_strdown(ev->location, -1);

                if (g_strstr_len(title, -1, filter_low) 
                        || g_strstr_len(desc,  -1, filter_low)
                        || g_strstr_len(loc,   -1, filter_low)) {
                    g_ptr_array_add(arr, ev);
                } else {
                    ev_mgr_clear(ev, NULL);
                } 
                free(title);
                free(desc);
                free(loc);
            }
        }
    }
    g_array_free(id_arr, TRUE);
    free(filter_low);
    return arr;
}
/*
void ev_db_pereodic_analyze(char ***reults, int *entries, int *cols) 
{
}
*/
void ev_db_date_id_list_alloc(struct date_id_list* list[], const size_t list_size, 
        const size_t ids_size) 
{
    int i;

    /* Size check */
    if (list_size <=0 || ids_size <= 0) {
        list = NULL;
        return;
    }

    /* Check whether list is NULL or not */
    if (list == NULL) return;

    /* Allocate memory for list_size structures date_id_list */
    if ((*list = malloc(list_size * sizeof(struct date_id_list))) == NULL) { 
        list = NULL;
        return;
    }

    /* Allocate memory for ids array in each element of the list */
    for (i = 0; i < list_size; ++i) {
        if (((*list)[i].ids = malloc(ids_size * sizeof(int))) == NULL) {
            free(*list);
            list = NULL;
            return;
        }
        (*list)[i].ids_size = ids_size;
    }
}

void ev_db_date_id_list_free(AppData* app)
{
    int i;

    /* Check whether list is NULL or not */
    if (app->id_list) {
        for (i = 0; app->id_list[i].date > 0; i++) {
            if (app->id_list[i].ids)
                free(app->id_list[i].ids);
        }
        free(app->id_list);
    }

    /* Free ids arrays in each element */
    app->id_list = NULL;
    /* Free the whole list */

}

event* ev_sel_search_by_field(const char* field, const char* value, AppData* data, GError* error)
{
    int entries;
    int cols;
    char query[MAX_QUERY];
    event* result = NULL;

    /* Prepare SQL query */
    sprintf(query, SQL_STMT_SEARCH_BY_FIELD, field);
    sqlite3_stmt* stmt;
    sqlite3_prepare_v2(data->sqlite, query, -1, &stmt, NULL);

    GError* err = NULL;
    GPtrArray* arr = ev_db_sql_query_prep_str(stmt, &entries, &cols, data, &err, DB_TEXT, value, DB_END);
    sqlite3_finalize(stmt);

    if (err) {
        g_debug(err->message);
        ev_db_sql_query_clear_2(arr, cols);
        g_error_free(err);
        return NULL;
    }

    if (arr) {
        char **str = g_ptr_array_index(arr, 0);

        err = NULL;
        result = ev_mgr_new(NULL);

        if (err) {
            g_debug(err->message);
            ev_db_sql_query_clear_2(arr, cols);
            g_error_free(err);
            return NULL;
        }

        err = NULL;
        ev_sel_get_by_id(atoi(str[0]), result, data, &err);

    } else {
        return NULL;
    }

    ev_db_sql_query_clear_2(arr, cols);
    return result;
}

