#include <CMulticalendar.h>
#include <CCalendar.h>
#include <CEvent.h>
#include <CRecurrence.h>
#include <CParameters.h>
#include <CComponentDetails.h>
#include <iostream>
#include "cb.h"
#include <cstring>
#include <cstdlib>
extern "C"
{
#include "kimi.h"
#include <glib.h>
}

char* cb_pixmap = "iVBORw0KGgoAAAANSUhEUgAAAB8AAAAgCAYAAADqgqNBAAAABHNCSVQICAgIfAhkiAAAAAlwSFlz\
AAAN1wAADdcBQiibeAAAABl0RVh0U29mdHdhcmUAd3d3Lmlua3NjYXBlLm9yZ5vuPBoAAATISURB\
VEiJtdd5iJVVGAbw37l3ZhxznEkNHdPKbDEzQyJDC9soUygpIcoW2kNaDdppJSra96CCsAW0aLGV\
mjbbIMo2aSPazLKyTK1MU6fTH+dc+7zMvdeKPvjgO+95znnO8r7P+35ijGKM0AfnYjYexohK3395\
cSpexFJMK/Y1QQihBe/iTczBGizR4AkhlGOM3XX6R+N8HJPnX7keIK/udDyzgTt5CUfm72cxqQ72\
ClxWq78UQuiL83DOBux0P+yJAdlUbjBkC3xaq7MJZ6Arxvh+I3LMaCmH71d3x0q71ADfH7+GEGYU\
8F/EGOdUGhNxbyPWEMLw5nLYecyQ9vkF81B8VWdYN1owLL9D0VzpbMJoyRkaPdN36Oz7fqmkOy+m\
DZ3qHCv+xNoY44yeOpsyoKbHZqKNcfy7i37pFrWhKy96fozxzwbkTbU6S/gGW9cjxwXG6bLKPHt4\
DiNwMFaGEPo1GFs7FHExJuFWlGKM960HCKE9f36EdvyIRdKuxksevwa/YzVuiTFensfOlGL7UbTE\
GJ+sXkCTpEIP4X6UC3G6DWbn7416iONW6dROwte4CX2rxt+Dl3FmtnVW5mokKPPwYJWtvQZ2k0xy\
bZ35xuRFnlmXHFMQcW7BNjQfeWfBNgP75u+B+VpG9jDfdliM2/F8jLFnkQgh9MaVuflCtm2Ex3Fj\
jPH7AnxbbA8xxsV4RYqE6ueGPOfzWE5thbpDcpRFeDuEUJaE6MMY49VV2NH4oNBeLF1BcTO7Svd/\
KzqwjKoYDCG04iqMwqv4Q9LxWZJ3H1GF7yvd4zu1yEMIA3Bi3vGWGC5FRtp5CGFECOEMvCfd20SM\
le7vbcnxJscYV1Xt+kI8EmNcWrC1Wj/hjMUh2AdP4BQMxrqUupcUJgcUHGQRVmBqDYfcDj9gYME2\
AAuxY8E2LONCbp8iacE68s3QURjQgu9weA3iTfExjpaEalupYFiIa6qw03FvoT0Ns/K3rTLRYhyb\
jWVJkXoinpTvbFm+x5+xAA9gYg/4xxTKJ+yL5yrkEyRxGIUvcXYD4RmIA/M7GYPrYFvyIvsXbG3Y\
qkK+K14viMgC7FUAH4zrsWm9RdUgPx1z6/Q7C7/iLSl5LMX4AuA1SenG5fZYtG4AcbNUhA6v2siw\
Ivml+FbKUDuhqWqSbwwZsgTj8pGvleq4LSoOiUFVY9olMWku2DYfyZt9+K2ZoyrkY1RpeGHAJohC\
WJLJpmfscfgEt2GqJEKtUj1YxlxJ9Upy/Y9bcNrdXNQ7idfOMEhK+MuwZxX54Nz3OXphviREN2V8\
WUqZZ+NJf6ffnyQdGCkR7SL9E0zAoYHYn6cqJF24Kx9/MWN1dHRYPmGCudl51mb/eANPZMxCqRqa\
l++5RSoubsb++aRulpJJM3bvZGVvfqkklvvySp/Gyf5+flu+3Ip+/ZQlpRqFw6SCYGAIYWQ+kVXo\
jjGuySe5BJ9JAgTHShG1BuUBrP6DPpUdljBT+sO4s+rop0m/UFNyu5ckTJdgR+lnY7wkx5Ol5PF1\
xp4liVfE8TFGbTwziLXtfNtTAfH0P43nPHZvXCd5+s+ScH0hRdAJaMu4g0pc0sQRFbHHumJxAYbG\
GFf4l08IYTcpLLvqztPDDk5VFbf/1/sXeEFPOQlFuUQAAAAASUVORK5CYII=";


CalendarBackendData::CalendarBackendData()
{
    CMulticalendar* multical = CMulticalendar::MCInstance();
    m_cal = multical->getDefaultCalendar();
    delete multical;
}

CalendarBackendData::~CalendarBackendData()
{
    delete m_cal;
}

void CalendarBackendData::store_event(Event* ev)
{
    CEvent* cev = convert_to_cevent(ev);
    int err = 0;
    
    if (ev->id != NULL) {
        m_cal->modifyEvent(cev, err);
    } else {
        m_cal->addEvent(cev, err);
        ev->id = strdup(cev->getId().c_str());
    }
    delete cev;
}

GPtrArray* CalendarBackendData::get_events_by_period(time_t start, time_t end)
{
    int code;
    GPtrArray* ret = g_ptr_array_new();

    vector<CEvent*> evs = m_cal->getEvents(code);
    
    for (int i = 0; i < evs.size(); i++) {
        if (evs[i]->getRecurrence()) {
            if (evs[i]->getRecurrence()->checkInstances(start, end, evs[i]->getDateStart(), 
                        evs[i]->getDateEnd() - evs[i]->getDateStart(), 0, "")) {
                g_ptr_array_add(ret, convert_to_event(evs[i]));
            }
        } else if (evs[i]->getDateStart() < end && evs[i]->getDateStart() > start) { 
            g_ptr_array_add(ret, convert_to_event(evs[i]));
        }

        delete evs[i];
    }
    return ret;
}

int CalendarBackendData::remove_event(const char* id)
{
    int code;
    m_cal->deleteEvent(id, code);
    return code;
}

CEvent* CalendarBackendData::convert_to_cevent(Event* ev)
{
    CEvent* cev = new CEvent();
    CParameters* type = new CParameters();
/*    
    ParamType t;
    t.i = 0;//ev->id_type;
    t.szString = "par_str";
    type->setParamValue(t);
    type->setParamName("type_event");
    vector<CParameters*> ps;
    ps.push_back(type);
    map<string, vector<CParameters*> > m = cev->getHashMap();
    m.insert(pair<string, vector<CParameters*> > ("type_event", ps));
    cev->setHashMap(m);
*/



    if (ev->id != NULL)
        cev->setId(ev->id);
    if (ev->title != NULL)
        cev->setSummary(ev->title);
    if (ev->description != NULL)
        cev->setDescription(ev->description);
    if (ev->location != NULL)
        cev->setLocation(ev->location);
    
    cev->setDateStart(ev->start_time);
    cev->setDateEnd(ev->end_time);
    
    if (ev->per) {
        vector<CRecurrenceRule*> ruls;
        for (int i = 0; i < ev->per->len; i++) {
            Rule* rul = (Rule*)g_ptr_array_index(ev->per, i);
            CRecurrenceRule* crul = new CRecurrenceRule(0, kimi_per_get_ical(rul));
            ruls.push_back(crul);
        }
        CRecurrence* rec = new CRecurrence();
        rec->setRecurrenceRule(ruls);
        cev->setRecurrence(rec);
    }

    return cev;
}

Event* CalendarBackendData::convert_to_event(CComponent* cev)
{
/*
    CComponentDetails* de = dynamic_cast<CComponentDetails*>(cev);
    int o = de->getHashMap()["type_event"][0]->getParamValue().i;
    g_debug("aa %d", o);
*/

    Event* ev = kimi_event_new(NULL);
    ev->id = strdup(cev->getId().c_str());
    ev->title = strdup(cev->getSummary().c_str());
    ev->description = strdup(cev->getDescription().c_str());
    ev->location = strdup(cev->getLocation().c_str());
    
    ev->start_time = cev->getDateStart();
    ev->end_time = cev->getDateEnd();
   
    ev->id_type = ev->start_time == ev->end_time ? 1 : 0;

    CRecurrence* rec = cev->getRecurrence();
    if (rec) {
        vector<CRecurrenceRule*> ruls = rec->getRecurrenceRule();
    
        if (ruls.size() > 0) {
            Period* per = kimi_per_create_period();
            for (int i = 0; i < ruls.size(); i++) {
                Rule* rul = kimi_per_create_rule_from_ical(ruls[i]->getRrule().c_str(), 0, 1);
                kimi_per_add_rule(per, rul);
            }
            ev->per = per;
        }
    }

    return ev;
}

extern "C"
int store_event(Event* event, Kimi* data, GError** error)
{
    CalendarBackendData* cbdata = reinterpret_cast<CalendarBackendData*>
                                    (kimi_get_module_data(MOD_ID, data, NULL));
    cbdata->store_event(event);

    //kimi_conf_show_all_options_to_user(cbdata->conf, "Messag", NULL);

    return 0;
}

extern "C"
GPtrArray* get_events_by_period(time_t start, time_t end, Kimi* data, GError** error)
{
    CalendarBackendData* cbdata = reinterpret_cast<CalendarBackendData*>
                                    (kimi_get_module_data(MOD_ID, data, NULL));
    return cbdata->get_events_by_period(start, end);
}

extern "C"
int remove_event(const char* id, Kimi* data, GError** error)
{
    CalendarBackendData* cbdata = reinterpret_cast<CalendarBackendData*>
                                    (kimi_get_module_data(MOD_ID, data, NULL));
                                    
    cbdata->remove_event(id);
    return 0;
}

extern "C"
void deinitialize(Kimi* data, Module* mod)
{
    CalendarBackendData* cbdata = reinterpret_cast<CalendarBackendData*>
                                    (kimi_get_module_data(MOD_ID, data, NULL));
    delete cbdata;
    free(mod->service_string);
    free(mod->service_name);
    
}

extern "C"
void kimi_module_initialize(Kimi* kimi, Module* mod)
{
    CalendarBackendData* cbdata = new CalendarBackendData();
    
/*    cbdata->conf = kimi_conf_create_config_module(kimi, MOD_ID, "C-B", NULL);
    kimi_conf_register_option(cbdata->conf,
            "login",
            "Login",
            OT_STRING,
            OF_DISPLAYABLE | OF_STORABLE,
            NULL);
    
    kimi_conf_register_option(cbdata->conf,
            "password",
            "Password",
            OT_PASSWORD,
            OF_DISPLAYABLE | OF_STORABLE,
            NULL);
  */
    //kimi_conf_show_all_options_to_user(cbdata->conf, "OOOOAAAAA", NULL);
    mod->data = (void*) cbdata;    
    mod->service_string = strdup(MOD_ID);
    mod->service_name = strdup(MOD_NAME);
    mod->store_event = store_event;
    mod->get_events_by_period = get_events_by_period;
    mod->remove_event = remove_event;
    mod->deinitialize = deinitialize;
    mod->service_pixmap = (void*) cb_pixmap; 
    g_debug("Calendar Backend Module initialized");
}
