#include "kimi.h"
#include <stdlib.h>

#define KS_SET_EVENT_FIELD(ev, field, str)\
    if (ev->field != NULL) {\
        free(ev->field);\
    }\
    ev->field = strdup(str);

void kimi_event_set_id(Event* ev, const char* str)
{
    KS_SET_EVENT_FIELD(ev, id, str);
}

void kimi_event_set_title(Event* ev, const char* str)
{
    KS_SET_EVENT_FIELD(ev, title, str);
}

void kimi_event_set_description(Event* ev, const char* str)
{
    KS_SET_EVENT_FIELD(ev, description, str);
}

void kimi_event_set_location(Event* ev, const char* str)
{
    KS_SET_EVENT_FIELD(ev, location, str);
}

void kimi_event_set_period(Event* ev, Period* per)
{
    if (ev->per != NULL) {
        kimi_per_free_period(per);
    }
    ev->per = per;
}


const char* kimi_event_get_id(Event* ev)
{
    return ev->id;
}

const char* kimi_event_get_title(Event* ev)
{
    return ev->title;
}

const char* kimi_event_get_description(Event* ev)
{
    return ev->description;
}

const char* kimi_event_get_location(Event* ev)
{
    return ev->location;
}

Period* kimi_event_get_period(Event* ev)
{
    return ev->per;
}

