#include <windows/wsettings.h>
#include <windows/callbacks.h>

void init_wsettings(GtkWidget* w, AppData* data)
{
    GtkWidget* win;
    GtkBox* vbox;
    GtkWidget* panarea;
    GtkWidget* button;
    GPtrArray* modules;
    Module* module;
    int i;
    int hildon_size;

    win = hildon_stackable_window_new();
    vbox = GTK_BOX (gtk_vbox_new (FALSE, 10));
    panarea = hildon_pannable_area_new ();

    modules = kimi_get_modules(data->kimi);

    if(modules->len > 3) {
        hildon_size = HILDON_SIZE_FINGER_HEIGHT;
    } else {
        hildon_size = HILDON_SIZE_AUTO;
    }

    for (i = 0; i < modules->len; i++) {
	    module = g_ptr_array_index(modules, i);
        button = hildon_button_new_with_text(hildon_size,
                                             HILDON_BUTTON_ARRANGEMENT_HORIZONTAL,
                                             module->service_name,
                                             "");
        gtk_widget_set_name(GTK_WIDGET(button), module->service_name);
        g_signal_connect(G_OBJECT(button), "clicked", G_CALLBACK(settings_module), data);
        gtk_container_add(GTK_CONTAINER(vbox), GTK_WIDGET(button));
    }

    hildon_pannable_area_add_with_viewport(HILDON_PANNABLE_AREA(panarea), vbox);
    gtk_container_add (GTK_CONTAINER(win), GTK_WIDGET(panarea));

    gtk_window_set_title(GTK_WINDOW(win), "Settings");

    gtk_widget_show_all(win);    
}

void settings_module(GtkWidget* button, AppData* data)
{
    GPtrArray* options;
    GPtrArray* modules;
    GPtrArray* config_modules;
    Module* module;
    ConfigModule* config_module;
    gchar* button_name;
    int i;
    
    button_name = gtk_widget_get_name(button);
    modules = kimi_get_modules(data->kimi);

    for (i = 0; i < modules->len; i++) {
        module = g_ptr_array_index(modules, i);
        if(strcmp(module->service_name, button_name) == 0) {
            break;
        }
    }
    
    //g_debug("%d %d", i, modules->len);
    if(i == modules->len - 1) {
        show_banner("This module don't have the settings", NULL);	
	return;    
    }
    
    config_modules = kimi_conf_get_config_modules(data->kimi);
    
    for(i = 0; i < config_modules->len; i++){
        config_module = g_ptr_array_index(config_modules, i);
	if(strcmp(module->service_name, config_module->id) == 0) {
	    break;
	}
    }
        
    /* get all settings for module */
    options = kimi_conf_get_options(config_module);

    /* show settings for this module */
    show_options(NULL, module->service_name, NULL, options);
}

static void save_option(Option* opt, GtkWidget* widget)
{
    gchar* str;
    gchar* pass_str;
    int boolean;
    int integer;

    switch (opt->type) {
        case OT_STRING:   /**< Text input field */
        str = gtk_entry_get_text(widget);
        kimi_conf_option_set_string(opt, str);
        break;

        case OT_PASSWORD: /**< Password input field (gui should display entering symbols as "*") */
        pass_str = gtk_entry_get_text(widget);
        kimi_conf_option_set_string(opt, pass_str);
        break;

        case OT_BOOLEAN:  /**< Check filed, that has two states - enabled, disabled */
        boolean = hildon_picker_button_get_active(widget);
        kimi_conf_option_set_boolean(opt, boolean);
        break;

        case OT_INTEGER:  /**< Integer tyoe */
        integer = hildon_number_editor_get_value(widget);
        kimi_conf_option_set_int(opt, integer);
        break;

        case OT_SELECT:   /**< Choose from several options */
        break;
    } 
}

static void on_dialog_response (GtkDialog *dialog, gint response_id, GPtrArray* view_settings)
{
    int i;
    GtkWidget* widget;
    Option* opt;
    GPtrArray* options;
    
    options = g_ptr_array_index(view_settings, 0);
    
    if (response_id == GTK_RESPONSE_OK){
        /* save */
        for(i = 1; i < view_settings->len; i++) {
            opt = g_ptr_array_index(options, i-1);

            //if(opt->flags & OF_DISPLAYABLE) {
                widget = g_ptr_array_index(view_settings, i);
                save_option(opt, widget);
            //}
        }
	}
    
    g_ptr_array_free(view_settings, TRUE);

	gtk_widget_destroy(GTK_WIDGET(dialog));
}

/* string widget */
static GtkWidget* new_widget_ot_string(Option* opt)
{
    GtkWidget* entry;

    entry = hildon_entry_new(HILDON_SIZE_FINGER_HEIGHT);

    if(opt->value.state == OS_SET){
       hildon_entry_set_text(entry, opt->value.v_text);
    }

    return GTK_WIDGET(entry);
}

/* bool widget */
static GtkWidget* new_widget_ot_boolean(Option* opt)
{
    GtkWidget* button_bool;

    button_bool = HILDON_PICKER_BUTTON(hildon_picker_button_new(
                                       HILDON_SIZE_FINGER_HEIGHT,
                                       HILDON_BUTTON_ARRANGEMENT_HORIZONTAL));
    HildonTouchSelector *selector_type = HILDON_TOUCH_SELECTOR(hildon_touch_selector_new_text());
    hildon_picker_button_set_selector(button_bool, selector_type);
    hildon_touch_selector_append_text(selector_type, _("FALSE"));
    hildon_touch_selector_append_text(selector_type, _("TRUE"));
    
    if(opt->value.state == OS_SET){
        hildon_picker_button_set_active(button_bool, opt->value.v_boolean);
    } else {
        hildon_picker_button_set_active(button_bool, 0);
    }

    return GTK_WIDGET(button_bool);
}

/* select widget */
/*static GtkWidget* new_widget_ot_select(Option* opt)
{
    GtkWidget* button_select;

    button_select = HILDON_PICKER_BUTTON(hildon_picker_button_new(
                                         HILDON_SIZE_FINGER_HEIGHT,
                                         HILDON_BUTTON_ARRANGEMENT_HORIZONTAL));
    HildonTouchSelector *selector_type = HILDON_TOUCH_SELECTOR(hildon_touch_selector_new_text());
    hildon_picker_button_set_selector(button_select, selector_type);

    hildon_touch_selector_append_text(selector_type, _("TRUE"));
    hildon_touch_selector_append_text(selector_type, _("FALSE"));
    
    if(opt->value.state == OS_SET){
        hildon_picker_button_set_active(button_select, opt->value.v_boolean);
    } else {
        hildon_picker_button_set_active(button_select, 0);
    }

    return GTK_WIDGET(button_select);
}
*/

/* integer widget */
static GtkWidget* new_widget_ot_integer(Option* opt)
{
    GtkWidget* num_edit;

    num_edit = hildon_number_editor_new(0, 65535);

    if(opt->value.state == OS_SET){
        hildon_number_editor_set_value(num_edit, opt->value.v_int);
    }

    return GTK_WIDGET(num_edit);
}

/* create new option widget */
static GtkWidget* new_option_widget(Option* opt)
{
    GtkWidget* widget;

    switch (opt->type) {
        case OT_STRING:   /**< Text input field */
        widget = new_widget_ot_string(opt);
        break;

        case OT_PASSWORD: /**< Password input field (gui should display entering symbols as "*") */
        widget = new_widget_ot_string(opt); 
        gtk_entry_set_visibility(widget, FALSE);
        break;

        case OT_BOOLEAN:  /**< Check filed, that has two states - enabled, disabled */
        widget = new_widget_ot_boolean(opt);
        break;

        case OT_INTEGER:  /**< Integer tyoe */
        widget = new_widget_ot_integer(opt);
        break;

        case OT_SELECT:   /**< Choose from several options */
        break;
    }
 
    return GTK_WIDGET(widget);
}

/* line setting widget */
static GtkWidget* new_line_widget(Option* opt, GtkWidget* widget)
{
    GtkWidget* hbox;
    GtkWidget* label;

    hbox = gtk_hbox_new(FALSE, 0);
    label = gtk_label_new(opt->string);

    gtk_container_add(GTK_CONTAINER(hbox), label);
    gtk_container_add(GTK_CONTAINER(hbox), widget);

    return GTK_WIDGET(hbox);
}

void show_options(ConfigModule* cm, const char* title, const char* message, GPtrArray* options)
{
    GtkWidget* dialog;
    GtkWidget* apply_button;
    GtkWidget* panarea;
    GtkWidget* hbox;
    GtkWidget* vbox;
    GtkWidget* label;
    GtkWidget* widget;
    Option* opt;
    int i;
    gchar* dialog_title;

    GPtrArray* view_settings; 
    view_settings = g_ptr_array_new();    

    /* add options */
    g_ptr_array_add(view_settings, options);

    dialog = gtk_dialog_new();
    apply_button = gtk_dialog_add_button(GTK_DIALOG(dialog), GTK_STOCK_APPLY, GTK_RESPONSE_OK);

    /* create dialog */
    dialog_title = g_strconcat(title, "\n", message, NULL);
    gtk_window_set_title(GTK_WINDOW(dialog), dialog_title);
    g_free(dialog_title);   
 
    panarea = hildon_pannable_area_new();    
    vbox = gtk_vbox_new(FALSE, 0);   
 
    for (i = 0; i < options->len; i++) {
        opt = g_ptr_array_index(options, i);

        widget = new_option_widget(opt);
        /* save widget in array */
        g_ptr_array_add(view_settings, widget);  
        hbox = new_line_widget(opt, widget);
        gtk_container_add(GTK_CONTAINER(vbox), hbox);
    }

    hildon_pannable_area_add_with_viewport(HILDON_PANNABLE_AREA(panarea), vbox);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), panarea, TRUE, TRUE, 0);
	gtk_widget_set_size_request(dialog, -1, 300);

    /* response */
    g_signal_connect(G_OBJECT(dialog), "response", G_CALLBACK(on_dialog_response), view_settings);

    gtk_widget_show_all(GTK_WIDGET (dialog));
    gtk_dialog_run(GTK_DIALOG (dialog));  

    return;
}

