#include "check_libkimi_module.h"
#include "kimi.h"
#include <string.h>
#include <stdlib.h>
#include <check.h>
static int store_event(Event* event, Kimi* data, GError** error)
{
    CHData* mdata = check_libkimi_get_data(data);

    if (mdata->error) {
        g_set_error(error, 
                CH_ERROR,
                5,
                "Error"
                );
        return -1;
    }

    mdata->stored_event = event;
    return 0;
}

static int remove_event(const char *id, Kimi *data, GError** error)
{
    CHData* mdata = check_libkimi_get_data(data);
    mdata->deleted_event = id;
    return 0;
}



static void deinitialize(Kimi* data, Module* mod)
{
    free(mod->service_name);
    free(mod->service_string);
}

void check_libkimi_initialize(Kimi* data)
{
    Module* mod = calloc(1, sizeof(Module));
    mod->service_name = strdup("Check module");
    mod->service_string = strdup(MOD_ID);
    mod->deinitialize = deinitialize;
    mod->store_event = store_event;
    mod->remove_event = remove_event;
    CHData* mdata = calloc(1, sizeof(CHData));
    mod->data = (void*) mdata;

    mdata->test_value = 256;

    kimi_register_module(mod, data, NULL);
}

void check_libkimi_initialize_2(Kimi* data)
{
    Module* mod = calloc(1, sizeof(Module));
    mod->service_name = strdup("Check module");
    mod->service_string = strdup(MOD_ID);
    mod->deinitialize = deinitialize;
    mod->store_event = store_event;
    mod->remove_event = remove_event;
    CHData* mdata = calloc(1, sizeof(CHData));
    mod->data = (void*) mdata;

    mdata->test_value = 256;
    int code = kimi_register_module(mod, data, NULL);
    fail_unless(code != 0);
}

CHData* check_libkimi_get_data(Kimi* data)
{
    return (CHData*) kimi_get_module_data(MOD_ID, data, NULL);
}

void check_libkimi_init_data(CHData* mdata, Kimi* data)
{
    mdata->test_value = 256;
    if (mdata->stored_event) {
        kimi_event_free(mdata->stored_event, NULL);
        mdata->stored_event = NULL;
    }
}

void check_libkimi_settings_callback(ConfigModule* cm, const char* title, const char* message, GPtrArray* options)
{
    CHData* mdata = check_libkimi_get_data(cm->kimi);
    
    strcpy(mdata->opt_title, title);
    strcpy(mdata->opt_message, message);

    mdata->options = options;
}

static void devnull_error_handler(const gchar *log_domain,
                                  GLogLevelFlags log_level,
                                  const gchar *message,
                                  gpointer user_data)
{
    return;
}

void disable_log()
{
    g_log_set_handler(NULL, G_LOG_LEVEL_MASK
                     | G_LOG_FLAG_FATAL
                     | G_LOG_FLAG_RECURSION,
                      devnull_error_handler, NULL);
}

void enable_log()
{
    g_log_set_handler(NULL, G_LOG_LEVEL_MASK
                     | G_LOG_FLAG_FATAL
                     | G_LOG_FLAG_RECURSION,
                      g_log_default_handler, NULL);
}
